/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.formatting;

import java.util.regex.Pattern;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.model.TextPM;
import org.beanfabrics.support.Validation;

public class PhoneNumberPM
extends TextPM {
    private Pattern pattern = Pattern.compile("[0-9]{3}-[0-9]{7}");

    public PhoneNumberPM() {
        PMManager.setup((PresentationModel)this);
    }

    @Validation(message="Not a valid phone number! Expecting format xxx-xxxxxxx")
    public boolean isPhoneNumber() {
        return this.pattern.matcher(this.getText()).matches();
    }

    public void reformat() {
        String text = this.getText().replaceAll("[^0-9-]", "");
        if (!text.contains("-") && text.length() > 3) {
            text = text.substring(0, 3).concat("-").concat(text.substring(3));
        }
        this.setText(text);
    }
}

