/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.util.ExceptionUtil;

public class BnPlainDocument
extends PlainDocument
implements View<ITextPM> {
    private boolean pending_modelChange = false;
    private boolean suppressRemoveEvent = false;
    protected ITextPM pModel;
    private final WeakPropertyChangeListener propertyListener = new MyWeakPropertyChangeListener();

    public BnPlainDocument() {
    }

    public BnPlainDocument(ITextPM pModel) {
        this();
        this.setPresentationModel(pModel);
    }

    public ITextPM getPresentationModel() {
        return this.pModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPresentationModel(ITextPM pModel) {
        if (this.isConnected()) {
            this.pModel.removePropertyChangeListener("text", (PropertyChangeListener)this.propertyListener);
        }
        this.pModel = pModel;
        if (pModel != null) {
            pModel.addPropertyChangeListener("text", (PropertyChangeListener)this.propertyListener);
        }
        try {
            this.pending_modelChange = true;
            this.refresh();
        }
        finally {
            this.pending_modelChange = false;
        }
    }

    public boolean isConnected() {
        return this.pModel != null;
    }

    private void disconnect() {
        if (this.isConnected()) {
            this.pModel.removePropertyChangeListener("text", (PropertyChangeListener)this.propertyListener);
        }
    }

    private void connect() {
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener("text", (PropertyChangeListener)this.propertyListener);
        }
    }

    protected void refresh() {
        try {
            String edText = this.isConnected() ? this.pModel.getText() : "";
            this.applyText(edText);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyText(String text) throws BadLocationException {
        String oldText = this.getText(0, this.getLength());
        if (!oldText.equals(text)) {
            this.suppressRemoveEvent = true;
            try {
                this.remove(0, this.getLength());
            }
            finally {
                this.suppressRemoveEvent = false;
            }
            this.insertString(0, text, null);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        try {
            String edText = this.isConnected() ? this.pModel.getText() : "";
            super.remove(offs, len);
            String newText = this.getText(0, this.getLength());
            if (!edText.equals(newText) && !this.suppressRemoveEvent && this.isConnected()) {
                this.pModel.setText(newText);
            }
        }
        catch (BadLocationException ex) {
            throw ex;
        }
        catch (Throwable t) {
            ExceptionUtil.getInstance().handleException("Error during editing.", t);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.isConnected()) {
            String edText = this.pModel.getText();
            super.insertString(offs, str, a);
            String newText = this.getText(0, this.getLength());
            if (!edText.equals(newText)) {
                this.pModel.setText(newText);
            }
        }
    }

    public void setSuppressRemoveEvent(boolean suppressRemoveEvent) {
        this.suppressRemoveEvent = suppressRemoveEvent;
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (!BnPlainDocument.this.pending_modelChange) {
                try {
                    BnPlainDocument.this.pending_modelChange = true;
                    BnPlainDocument.this.refresh();
                }
                finally {
                    BnPlainDocument.this.pending_modelChange = false;
                }
            }
        }
    }
}

