/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.internal;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.IBooleanPM;
import org.beanfabrics.util.ExceptionUtil;

public class BooleanPMMenuItem
extends JCheckBoxMenuItem
implements View<IBooleanPM> {
    private IBooleanPM pModel;
    private boolean iconSetManually = false;
    private boolean textSetManually = false;
    private final WeakPropertyChangeListener listener = new MyWeakPropertyChangeListener();

    public BooleanPMMenuItem() {
        this.init();
    }

    public BooleanPMMenuItem(IBooleanPM pModel) {
        this();
        this.setPresentationModel(pModel);
    }

    private void init() {
        this.setEnabled(false);
    }

    public IBooleanPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IBooleanPM newModel) {
        IBooleanPM oldModel = this.pModel;
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.pModel = newModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    boolean isConnected() {
        return this.pModel != null;
    }

    @Override
    protected void fireActionPerformed(ActionEvent evt) {
        if (this.isConnected()) {
            try {
                this.execute();
                super.fireActionPerformed(evt);
            }
            catch (Throwable t) {
                ExceptionUtil.getInstance().handleException("Error during invocation of operation", t);
            }
        } else {
            super.fireActionPerformed(evt);
        }
    }

    protected void execute() throws Throwable {
        this.pModel.setBoolean(Boolean.valueOf(this.getState()));
    }

    protected void refresh() {
        if (this.isConnected()) {
            try {
                Boolean value = this.pModel.getBoolean();
                if (value != null) {
                    this.setSelected(value);
                }
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            boolean isValid = this.pModel.isValid();
            this.setEnabled(isValid);
            this.setToolTipText(isValid ? this.pModel.getDescription() : this.pModel.getValidationState().getMessage());
            if (!this.textSetManually) {
                String title = this.pModel.getTitle();
                if (title == null || title.length() == 0) {
                    title = "untitled operation";
                }
                super.setText(title);
            }
        } else {
            this.setSelected(false);
            this.setToolTipText(null);
            this.setEnabled(false);
            if (!this.iconSetManually) {
                super.setIcon(null);
            }
            if (!this.textSetManually) {
                super.setText(null);
            }
        }
    }

    @Override
    public void setIcon(Icon icon) {
        this.iconSetManually = icon != null;
        super.setIcon(icon);
        this.refresh();
    }

    @Override
    public void setText(String text) {
        this.textSetManually = text != null;
        super.setText(text);
        this.refresh();
    }

    @Override
    public synchronized void setState(boolean b) {
        super.setState(b);
        this.pModel.setBoolean(Boolean.valueOf(b));
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            BooleanPMMenuItem.this.refresh();
        }
    }
}

