/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.internal;

import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.swing.ErrorIconPainter;
import org.beanfabrics.swing.internal.BnPlainDocument;

public class TextPMTextArea
extends JTextArea
implements View<ITextPM> {
    private boolean selectAllOnFocusGainedEnabled = false;
    private boolean reformatOnFocusLostEnabled = true;
    private BnPlainDocument document;
    private final PropertyChangeListener listener = new MyWeakPropertyChangeListener();
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();

    public TextPMTextArea(int rows, int columns) {
        super(rows, columns);
        this.init();
    }

    public TextPMTextArea() {
        this.init();
    }

    public TextPMTextArea(ITextPM pModel) {
        this();
        this.setPresentationModel(pModel);
    }

    public boolean isSelectAllOnFocusGainedEnabled() {
        return this.selectAllOnFocusGainedEnabled;
    }

    public void setSelectAllOnFocusGainedEnabled(boolean selectAllOnFocusGainedEnabled) {
        this.selectAllOnFocusGainedEnabled = selectAllOnFocusGainedEnabled;
    }

    public boolean isReformatOnFocusLostEnabled() {
        return this.reformatOnFocusLostEnabled;
    }

    public void setReformatOnFocusLostEnabled(boolean reformatOnFocusLostEnabled) {
        this.reformatOnFocusLostEnabled = reformatOnFocusLostEnabled;
    }

    private void init() {
        this.setEnabled(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextPMTextArea.this.onFocusGained();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextPMTextArea.this.onFocusLost();
            }
        });
    }

    protected void onFocusGained() {
        this.repaint();
        if (this.isSelectAllOnFocusGainedEnabled()) {
            this.selectAll();
        }
    }

    protected void onFocusLost() {
        this.repaint();
        if (this.isReformatOnFocusLostEnabled() && this.isConnected()) {
            this.document.getPresentationModel().reformat();
        }
    }

    @Override
    protected Document createDefaultModel() {
        if (this.document != null && this.document.isConnected()) {
            throw new IllegalStateException("The document was initialized already.");
        }
        this.document = new BnPlainDocument();
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        if (this.isConnected()) {
            throw new IllegalStateException("The document was initialized already.");
        }
        if (document instanceof BnPlainDocument) {
            this.document = (BnPlainDocument)document;
        }
        super.setDocument(document);
    }

    public ITextPM getPresentationModel() {
        if (this.document == null) {
            return null;
        }
        return this.document.getPresentationModel();
    }

    public void setPresentationModel(ITextPM newModel) {
        ITextPM oldModel = this.document.getPresentationModel();
        if (oldModel != null) {
            oldModel.removePropertyChangeListener(this.listener);
        }
        this.document.setPresentationModel(newModel);
        if (newModel != null) {
            newModel.addPropertyChangeListener(this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    boolean isConnected() {
        return this.document != null && this.document.getPresentationModel() != null;
    }

    protected void refresh() {
        ITextPM pModel = this.getPresentationModel();
        if (pModel != null) {
            this.setEnabled(true);
            this.setToolTipText(!pModel.isValid() ? pModel.getValidationState().getMessage() : pModel.getDescription());
            this.setEditable(pModel.isEditable());
        } else {
            this.setEnabled(false);
        }
        this.repaint();
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        result.setVerticalAlignment(1);
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        ITextPM pModel = this.getPresentationModel();
        if (pModel == null) {
            return false;
        }
        return !pModel.isValid();
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TextPMTextArea.this.refresh();
        }
    }
}

