/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JLabel;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.IIconPM;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.swing.ErrorIconPainter;

public class BnLabel
extends JLabel
implements View<ITextPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private final PropertyChangeListener listener = new MyWeakPropertyChangeListener();
    private ITextPM pModel;
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();

    public BnLabel() {
    }

    public BnLabel(ITextPM pModel) {
        this();
        this.setPresentationModel(pModel);
    }

    public BnLabel(ModelProvider provider, Path path) {
        this.setModelProvider((IModelProvider)provider);
        this.setPath(path);
    }

    public BnLabel(ModelProvider provider) {
        this.setModelProvider((IModelProvider)provider);
        this.setPath(new Path());
    }

    boolean isConnected() {
        return this.pModel != null;
    }

    private void refresh() {
        this.refreshText();
        this.refreshIcon();
        this.refreshToolTip();
    }

    private void refreshToolTip() {
        if (this.pModel == null) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(!this.pModel.isValid() ? this.pModel.getValidationState().getMessage() : this.pModel.getDescription());
        }
    }

    private void refreshIcon() {
        if (this.pModel instanceof IIconPM) {
            IIconPM iconEditor = (IIconPM)this.pModel;
            this.setIcon(iconEditor.getIcon());
        } else {
            this.setIcon(null);
        }
    }

    private void refreshText() {
        if (this.pModel == null) {
            this.setText("");
        } else {
            this.setText(this.pModel.getText());
        }
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        result.setHorizontalAlignment(this.invertHorizontalAlignment(this.getHorizontalAlignment()));
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        ITextPM pModel = this.getPresentationModel();
        if (pModel == null) {
            return false;
        }
        return !pModel.isValid();
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        super.setHorizontalAlignment(alignment);
        if (this.errorIconPainter != null) {
            this.errorIconPainter.setHorizontalAlignment(this.invertHorizontalAlignment(alignment));
        }
    }

    private int invertHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 2: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 10;
            }
        }
        return alignment;
    }

    public ITextPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(ITextPM newModel) {
        ITextPM oldModel = this.pModel;
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
        }
        this.pModel = newModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            BnLabel.this.refresh();
        }
    }
}

