/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.beanfabrics.Path;
import org.beanfabrics.PathEvaluation;
import org.beanfabrics.event.ElementChangedEvent;
import org.beanfabrics.event.ElementsAddedEvent;
import org.beanfabrics.event.ElementsDeselectedEvent;
import org.beanfabrics.event.ElementsRemovedEvent;
import org.beanfabrics.event.ElementsReplacedEvent;
import org.beanfabrics.event.ElementsSelectedEvent;
import org.beanfabrics.event.ListListener;
import org.beanfabrics.event.WeakListListener;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.IOperationPM;
import org.beanfabrics.model.IValuePM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.model.SortKey;
import org.beanfabrics.swing.table.BnColumn;

public class BnTableModel
extends AbstractTableModel {
    private IListPM list;
    private boolean cellEditingAllowed;
    private List<BnColumn> colDefs = new ArrayList<BnColumn>();
    private final ListListener listener = new MyWeakListListener();

    public BnTableModel(IListPM aListModel, List<BnColumn> colDefs, boolean editingAllowed) {
        if (aListModel == null) {
            throw new IllegalArgumentException("aListModel must not be null");
        }
        if (colDefs == null) {
            throw new IllegalArgumentException("colDefs must not be null");
        }
        this.list = aListModel;
        this.cellEditingAllowed = editingAllowed;
        this.colDefs.addAll(colDefs);
        this.list.addListListener(this.listener);
    }

    public void dismiss() {
        this.list.removeListListener(this.listener);
    }

    public void setCellEditingAllowed(boolean editingAllowed) {
        boolean oldValue = this.cellEditingAllowed;
        this.cellEditingAllowed = editingAllowed;
        if (oldValue != this.cellEditingAllowed) {
            this.fireTableStructureChanged();
        }
    }

    public boolean isCellEditingAllowed() {
        return this.cellEditingAllowed;
    }

    public List<BnColumn> getColDefs() {
        return Collections.unmodifiableList(this.colDefs);
    }

    public void setColDefs(List<BnColumn> colDefs) {
        if (colDefs == null) {
            throw new IllegalArgumentException("colDefs==null");
        }
        this.colDefs.clear();
        this.colDefs.addAll(colDefs);
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return this.colDefs.size();
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Path path = this.colDefs.get(columnIndex).getPath();
        PresentationModel rowMdl = this.list.getAt(rowIndex);
        return PathEvaluation.evaluateOrNull((PresentationModel)rowMdl, (Path)path);
    }

    @Override
    public String getColumnName(int column) {
        BnColumn def = this.colDefs.get(column);
        if (def == null) {
            return null;
        }
        return def.getColumnName();
    }

    public Path getColumnPath(int column) {
        BnColumn def = this.colDefs.get(column);
        if (def == null) {
            return null;
        }
        return def.getPath();
    }

    @Override
    public int findColumn(String columnName) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!columnName.equals(this.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return PresentationModel.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.cellEditingAllowed) {
            return false;
        }
        Object value = this.getValueAt(rowIndex, columnIndex);
        if (value instanceof IValuePM) {
            return ((IValuePM)value).isEditable();
        }
        if (value instanceof IOperationPM) {
            return ((IOperationPM)value).isEnabled();
        }
        return false;
    }

    public IListPM getPresentationModel() {
        return this.list;
    }

    public SortKey getSortKey(int col) {
        Path colPath = this.getColumnPath(col);
        if (colPath == null) {
            return null;
        }
        Collection<SortKey> sortKeys = this.getSortKeys();
        for (SortKey sortKey : sortKeys) {
            if (!colPath.equals((Object)sortKey.getSortPath())) continue;
            return sortKey;
        }
        return null;
    }

    public Collection<SortKey> getSortKeys() {
        Collection sortKeys = this.list.getSortKeys();
        return sortKeys;
    }

    private class MyWeakListListener
    implements WeakListListener,
    Serializable {
        private MyWeakListListener() {
        }

        public void elementsSelected(ElementsSelectedEvent evt) {
        }

        public void elementsDeselected(ElementsDeselectedEvent evt) {
        }

        public void elementChanged(ElementChangedEvent evt) {
            BnTableModel.this.fireTableRowsUpdated(evt.getIndex(), evt.getIndex());
        }

        public void elementsReplaced(ElementsReplacedEvent evt) {
            BnTableModel.this.fireTableRowsUpdated(evt.getBeginIndex(), evt.getBeginIndex() + evt.getLength() - 1);
        }

        public void elementsAdded(ElementsAddedEvent evt) {
            BnTableModel.this.fireTableRowsInserted(evt.getBeginIndex(), evt.getBeginIndex() + evt.getLength() - 1);
        }

        public void elementsRemoved(ElementsRemovedEvent evt) {
            BnTableModel.this.fireTableRowsDeleted(evt.getBeginIndex(), evt.getBeginIndex() + evt.getLength() - 1);
        }
    }
}

