/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.beanfabrics.event.ElementChangedEvent;
import org.beanfabrics.event.ElementsAddedEvent;
import org.beanfabrics.event.ElementsDeselectedEvent;
import org.beanfabrics.event.ElementsRemovedEvent;
import org.beanfabrics.event.ElementsReplacedEvent;
import org.beanfabrics.event.ElementsSelectedEvent;
import org.beanfabrics.event.ListListener;
import org.beanfabrics.event.WeakListListener;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.PresentationModel;

public class BnTableSelectionModel
implements ListSelectionModel {
    private IListPM<? extends PresentationModel> list;
    private ListListener listener = new WeakListListener(){

        public void elementsDeselected(ElementsDeselectedEvent evt) {
            int index0 = Math.min(BnTableSelectionModel.this.leadSelectionIndex, BnTableSelectionModel.this.anchorSelectionIndex);
            index0 = Math.min(index0, evt.getBeginIndex());
            int index1 = Math.max(BnTableSelectionModel.this.leadSelectionIndex, BnTableSelectionModel.this.anchorSelectionIndex);
            index1 = Math.max(index1, evt.getBeginIndex() + evt.getLength() - 1);
            BnTableSelectionModel.this.fireValueChanged(index0, index1 - index0 + 1);
        }

        public void elementsSelected(ElementsSelectedEvent evt) {
            int index0 = Math.min(BnTableSelectionModel.this.leadSelectionIndex, BnTableSelectionModel.this.anchorSelectionIndex);
            index0 = Math.min(index0, evt.getBeginIndex());
            int index1 = Math.max(BnTableSelectionModel.this.leadSelectionIndex, BnTableSelectionModel.this.anchorSelectionIndex);
            index1 = Math.max(index1, evt.getBeginIndex() + evt.getLength() - 1);
            if (BnTableSelectionModel.this.leadSelectionIndex == -1) {
                BnTableSelectionModel.this.leadSelectionIndex = evt.getBeginIndex();
            }
            BnTableSelectionModel.this.fireValueChanged(index0, index1 - index0 + 1);
        }

        public void elementChanged(ElementChangedEvent evt) {
        }

        public void elementsAdded(ElementsAddedEvent evt) {
            if (BnTableSelectionModel.this.leadSelectionIndex >= evt.getBeginIndex()) {
                BnTableSelectionModel.this.leadSelectionIndex += evt.getLength();
            }
        }

        public void elementsRemoved(ElementsRemovedEvent evt) {
            if (BnTableSelectionModel.this.leadSelectionIndex >= evt.getBeginIndex() && BnTableSelectionModel.this.leadSelectionIndex <= evt.getBeginIndex() + evt.getLength()) {
                BnTableSelectionModel.this.leadSelectionIndex = -1;
            }
        }

        public void elementsReplaced(ElementsReplacedEvent evt) {
        }
    };
    private final CopyOnWriteArrayList<ListSelectionListener> eventListeners = new CopyOnWriteArrayList();
    private int selectionMode = 2;
    private boolean valueIsAdjusting = false;
    private int anchorSelectionIndex = -1;
    private int leadSelectionIndex = -1;
    private int minLastChangedIndex = -1;
    private int maxLastChangedIndex = -1;

    public BnTableSelectionModel(IListPM<? extends PresentationModel> pModel) {
        if (pModel == null) {
            throw new IllegalArgumentException("pModel must not be null");
        }
        this.list = pModel;
        this.list.addListListener(this.listener);
    }

    public void dismiss() {
        this.list.removeListListener(this.listener);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener l) {
        if (l == null) {
            throw new IllegalArgumentException("l must not be null.");
        }
        this.eventListeners.add(l);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener l) {
        if (l == null) {
            throw new IllegalArgumentException("l must not be null.");
        }
        this.eventListeners.remove(l);
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        switch (selectionMode) {
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = selectionMode;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        if (valueIsAdjusting == this.valueIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = valueIsAdjusting;
        int index0 = this.minLastChangedIndex;
        int index1 = this.maxLastChangedIndex;
        this.minLastChangedIndex = -1;
        this.maxLastChangedIndex = -1;
        if (!this.valueIsAdjusting && index0 != -1 && index1 != -1) {
            this.fireValueChangedBetween(index0, index1);
        }
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.list.getSelection().getMaxIndex();
    }

    @Override
    public int getMinSelectionIndex() {
        return this.list.getSelection().getMinIndex();
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.anchorSelectionIndex;
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        int oldAnchor = this.anchorSelectionIndex;
        this.anchorSelectionIndex = index;
        this.fireValueChangedBetween(oldAnchor, this.anchorSelectionIndex);
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.leadSelectionIndex;
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        int oldLead = this.leadSelectionIndex;
        this.leadSelectionIndex = index;
        this.fireValueChangedBetween(oldLead, this.anchorSelectionIndex);
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.list.getSelection().contains(index);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.list.getSelection().isEmpty();
    }

    @Override
    public void clearSelection() {
        this.list.getSelection().clear();
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (this.getSelectionMode() == 0) {
            index0 = index1;
        }
        int beginIndex = Math.min(index0, index1);
        int endIndex = Math.max(index0, index1);
        this.updateLeadAnchorIndices(index0, index1);
        if (index0 == -1) {
            this.list.getSelection().clear();
        } else {
            this.list.getSelection().setInterval(beginIndex, endIndex);
        }
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        if (index0 == -1 || index1 == -1) {
            return;
        }
        int beginIndex = Math.min(index0, index1);
        int endIndex = Math.max(index0, index1);
        if (this.getSelectionMode() == 0) {
            this.setSelectionInterval(index0, index1);
            return;
        }
        if (!(this.getSelectionMode() != 1 || this.list.getSelection().isEmpty() || this.list.getSelection().getMaxIndex() >= beginIndex && endIndex >= this.list.getSelection().getMinIndex())) {
            this.setSelectionInterval(index0, index1);
            return;
        }
        this.updateLeadAnchorIndices(index0, index1);
        this.list.getSelection().addInterval(beginIndex, endIndex);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        int beginIndex = Math.min(index0, index1);
        int endIndex = Math.max(index0, index1);
        if (this.getSelectionMode() != 2 && !this.list.getSelection().isEmpty() && this.list.getSelection().getMinIndex() < beginIndex && endIndex < this.list.getSelection().getMaxIndex()) {
            endIndex = Math.max(endIndex, this.list.getSelection().getMaxIndex());
        }
        this.updateLeadAnchorIndices(index0, index1);
        this.list.getSelection().removeInterval(beginIndex, endIndex);
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
    }

    protected void fireValueChangedBetween(int index0, int index1) {
        int beginIndex = Math.min(index0, index1);
        int endIndex = Math.max(index0, index1);
        int len = endIndex - beginIndex;
        this.fireValueChanged(beginIndex, len);
    }

    protected void fireValueChanged(int beginIndex, int length) {
        if (this.valueIsAdjusting) {
            this.markDirty(beginIndex);
            this.markDirty(beginIndex + length - 1);
        }
        if (this.eventListeners.isEmpty()) {
            return;
        }
        ListSelectionEvent evt = new ListSelectionEvent(this, beginIndex, beginIndex + length - 1, this.valueIsAdjusting);
        for (ListSelectionListener l : this.eventListeners) {
            l.valueChanged(evt);
        }
    }

    protected void updateLeadAnchorIndices(int index0, int index1) {
        if (index0 != index1 && this.valueIsAdjusting) {
            if (this.anchorSelectionIndex == -1) {
                this.anchorSelectionIndex = index0;
            }
            this.leadSelectionIndex = index1;
        } else {
            this.anchorSelectionIndex = index0;
            this.leadSelectionIndex = index1;
        }
    }

    protected void markDirty(int index) {
        if (this.valueIsAdjusting) {
            if (this.minLastChangedIndex == -1 || this.minLastChangedIndex > index) {
                this.minLastChangedIndex = index;
            }
            if (this.maxLastChangedIndex == -1 || this.maxLastChangedIndex < index) {
                this.maxLastChangedIndex = index;
            }
        }
    }
}

