/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.beanfabrics.Path;
import org.beanfabrics.log.Logger;
import org.beanfabrics.log.LoggerFactory;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.SortKey;
import org.beanfabrics.swing.table.BnTableModel;

public class Java5SortingTableHeader
extends JTableHeader {
    private static final Logger LOG = LoggerFactory.getLogger(Java5SortingTableHeader.class);
    private final MouseListener mouseListener = new MyMouseAdapter();
    private boolean sortable;

    public Java5SortingTableHeader() {
        this.installListeners();
    }

    public Java5SortingTableHeader(TableColumnModel cm) {
        super(cm);
        this.installListeners();
    }

    public void setSortable(boolean newValue) {
        this.sortable = newValue;
    }

    private void installListeners() {
        this.addMouseListener(this.mouseListener);
    }

    protected void onClick(MouseEvent e) {
        int visColIndex;
        if (this.sortable && (visColIndex = this.getTable().columnAtPoint(e.getPoint())) >= 0) {
            int modelColIndex = this.getColumnModel().getColumn(visColIndex).getModelIndex();
            this.toggleSortOrder(modelColIndex);
        }
    }

    private void toggleSortOrder(int modelColIndex) {
        TableModel tblModel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("toggling sort order for column index " + modelColIndex);
        }
        if ((tblModel = this.getTable().getModel()) instanceof BnTableModel) {
            BnTableModel model = (BnTableModel)tblModel;
            IListPM listPM = model.getPresentationModel();
            Path path = model.getColumnPath(modelColIndex);
            SortKey newSortKey = this.getNewSortKey(listPM, path);
            listPM.sortBy(new SortKey[]{newSortKey});
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Can't sort unknown table model: " + tblModel.getClass().getName());
        }
    }

    private SortKey getNewSortKey(IListPM listMdl, Path path) {
        Collection sortKeys = listMdl.getSortKeys();
        for (SortKey sortKey : sortKeys) {
            if (!sortKey.getSortPath().equals((Object)path)) continue;
            return new SortKey(!sortKey.isAscending(), path);
        }
        return new SortKey(true, path);
    }

    private class MyMouseAdapter
    extends MouseAdapter
    implements Serializable {
        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Java5SortingTableHeader.this.onClick(e);
        }
    }
}

