/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table.cellrenderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.beanfabrics.model.ConversionException;
import org.beanfabrics.model.IBooleanPM;
import org.beanfabrics.swing.ErrorIconPainter;

public class BooleanPMTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private CellRendererPane cellRendererPane = new CellRendererPane();
    private JCheckBox cb = new JCheckBox();
    private DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    private ErrorIconPainter errorIconPainter = this.createDefaultErrorIconPainter();
    private IBooleanPM model;
    private JComponent rendererComponent;

    public BooleanPMTableCellRenderer() {
        this.cb.setHorizontalAlignment(0);
        this.cb.setBorderPainted(false);
        this.cb.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.cb, "Center");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof IBooleanPM)) {
            return null;
        }
        this.model = (IBooleanPM)value;
        Boolean bvalue = false;
        try {
            Boolean modelBoolean = this.model.getBoolean();
            if (modelBoolean != null) {
                bvalue = modelBoolean;
            }
        }
        catch (ConversionException e) {
            // empty catch block
        }
        this.cb.setSelected(bvalue);
        this.cb.setEnabled(table.getModel().isCellEditable(row, column));
        if (this.isNimbus()) {
            if (this.rendererComponent != null) {
                this.rendererComponent.setBackground(null);
            }
            this.rendererComponent = (JComponent)this.defaultRenderer.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            if (!isSelected && row % 2 != 0) {
                this.rendererComponent.setBackground(Color.white);
            }
        } else {
            this.rendererComponent = (JComponent)this.defaultRenderer.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        }
        return this;
    }

    private boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.rendererComponent != null) {
            this.rendererComponent.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.rendererComponent != null) {
            this.rendererComponent.setForeground(fg);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.cellRendererPane.paintComponent(g, this.rendererComponent, this, 0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    private ErrorIconPainter createDefaultErrorIconPainter() {
        ErrorIconPainter result = new ErrorIconPainter();
        return result;
    }

    public ErrorIconPainter getErrorIconPainter() {
        return this.errorIconPainter;
    }

    public void setErrorIconPainter(ErrorIconPainter aErrorIconPainter) {
        if (aErrorIconPainter == null) {
            throw new IllegalArgumentException("aErrorIconPainter == null");
        }
        this.errorIconPainter = aErrorIconPainter;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.shouldPaintErrorIcon()) {
            this.errorIconPainter.paint(g, this);
        }
    }

    private boolean shouldPaintErrorIcon() {
        if (this.model == null) {
            return false;
        }
        return !this.model.isValid();
    }
}

