/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.beanfabrics.swing.customizer.CustomizerBase;
import org.beanfabrics.swing.customizer.CustomizerPM;
import org.beanfabrics.swing.customizer.util.CustomizerUtil;
import org.beanfabrics.swing.customizer.util.RootWindowLocator;

public class CustomizerBasePanel<PM extends CustomizerPM>
extends JPanel
implements CustomizerBase {
    private Object bean;
    private PM pModel;

    public CustomizerBasePanel(PM aPm) {
        this.pModel = aPm;
        this.pModel.getContext().addService(RootWindowLocator.class, (Object)CustomizerUtil.getRootWindowLocator(this));
    }

    @Override
    public void setObject(Object bean) {
        this.bean = bean;
        try {
            this.pModel.setCustomizer(this);
        }
        catch (Throwable t) {
            this.showException(t);
        }
    }

    @Override
    public Object getObject() {
        return this.bean;
    }

    @Override
    public void showMessage(String message) {
        this.removeAll();
        JTextArea ta = new JTextArea(message);
        ta.setForeground(Color.red);
        ta.setEditable(false);
        JScrollPane scroll = new JScrollPane(ta);
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
    }

    @Override
    public void showException(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Caught " + t.getClass().getName() + ": '" + t.getMessage() + "'");
        t.printStackTrace(pw);
        this.showMessage(sw.toString());
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }
}

