/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import org.beanfabrics.Path;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.SortKey;
import org.beanfabrics.swing.table.BnColumn;
import org.beanfabrics.swing.table.BnTable;
import org.beanfabrics.swing.table.BnTableModel;

public class BnTableRowSorter
extends RowSorter<BnTableModel> {
    private final BnTableModel model;
    private final PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BnTableRowSorter.this.sortKeys.refresh();
            BnTableRowSorter.this.fireSortOrderChanged();
        }
    };
    private final SortKeys sortKeys;
    private final IListPM list;

    public static BnTableRowSorter install(BnTable table) {
        table.setUpdateSelectionOnSort(false);
        BnTableModel model = (BnTableModel)table.getModel();
        BnTableRowSorter rowSorter = new BnTableRowSorter(model);
        table.setRowSorter(rowSorter);
        return rowSorter;
    }

    public static void uninstall(BnTable table) {
        RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
        if (rowSorter instanceof BnTableRowSorter) {
            ((BnTableRowSorter)rowSorter).dismiss();
        }
        table.setRowSorter(null);
    }

    public BnTableRowSorter(BnTableModel model) {
        this.model = model;
        int colNum = model.getColumnCount();
        this.sortKeys = new SortKeys(colNum);
        this.sortKeys.refresh();
        this.list = model.getPresentationModel();
        this.list.addPropertyChangeListener("sortKeys", this.pcl);
    }

    public void dismiss() {
        this.list.removePropertyChangeListener("sortKeys", this.pcl);
    }

    @Override
    public int convertRowIndexToModel(int index) {
        return index;
    }

    @Override
    public int convertRowIndexToView(int index) {
        return index;
    }

    @Override
    public BnTableModel getModel() {
        return this.model;
    }

    @Override
    public int getModelRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.sortKeys.asListByPrecedence();
    }

    @Override
    public int getViewRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
        SortKey[] modelSortKeys = new SortKey[this.sortKeys.size()];
        Iterator<RowSorter.SortKey> it = this.sortKeys.asListByPrecedence().iterator();
        for (int i = 0; i < modelSortKeys.length; ++i) {
            RowSorter.SortKey key = it.next();
            Path path = this.model.getColumnPath(key.getColumn());
            boolean ascending = key.getSortOrder() == SortOrder.ASCENDING;
            modelSortKeys[i] = new SortKey(ascending, path);
        }
        this.list.sortBy(modelSortKeys);
        this.fireRowSorterChanged(null);
    }

    @Override
    public void toggleSortOrder(int column) {
        RowSorter.SortKey sk = this.sortKeys.getSortKey(column);
        boolean ascending = sk == null ? true : sk.getSortOrder() != SortOrder.ASCENDING;
        Path path = this.model.getColumnPath(column);
        this.list.sortBy(ascending, new Path[]{path});
    }

    @Override
    public void modelStructureChanged() {
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
    }

    @Override
    public void allRowsChanged() {
    }

    private class SortKeys {
        private RowSorter.SortKey[] sortKeyByColumn;
        private RowSorter.SortKey[] sortKeyByPrecedence;
        private List<RowSorter.SortKey> cachedSortKeyListByPrecedence;

        public SortKeys(int columns) {
            this.sortKeyByColumn = new RowSorter.SortKey[columns];
            this.sortKeyByPrecedence = new RowSorter.SortKey[columns];
        }

        public int size() {
            return this.asListByPrecedence().size();
        }

        public RowSorter.SortKey getSortKey(int col) {
            return this.sortKeyByColumn[col];
        }

        public void clear() {
            Arrays.fill(this.sortKeyByColumn, null);
            Arrays.fill(this.sortKeyByPrecedence, null);
            this.cachedSortKeyListByPrecedence = null;
        }

        public List<RowSorter.SortKey> asListByPrecedence() {
            if (this.cachedSortKeyListByPrecedence == null) {
                ArrayList<RowSorter.SortKey> newSortKeyList = new ArrayList<RowSorter.SortKey>();
                for (RowSorter.SortKey sortKey : this.sortKeyByPrecedence) {
                    if (sortKey == null) continue;
                    newSortKeyList.add(sortKey);
                }
                this.cachedSortKeyListByPrecedence = Collections.unmodifiableList(newSortKeyList);
            }
            return this.cachedSortKeyListByPrecedence;
        }

        public void refresh() {
            if (this.sortKeyByColumn.length == 0) {
                return;
            }
            this.clear();
            Collection<SortKey> modelSortKeysByPrecedence = BnTableRowSorter.this.model.getSortKeys();
            int pos = 0;
            for (SortKey modelSortKey : modelSortKeysByPrecedence) {
                RowSorter.SortKey viewSortKey;
                int col = this.getFirstColumnIndexOf(modelSortKey.getSortPath());
                if (col == -1) continue;
                SortOrder sortOrder = modelSortKey.isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING;
                this.sortKeyByPrecedence[pos] = viewSortKey = new RowSorter.SortKey(col, sortOrder);
                this.sortKeyByColumn[col] = viewSortKey;
                ++pos;
            }
        }

        private int getFirstColumnIndexOf(Path path) {
            List<BnColumn> colDefs = BnTableRowSorter.this.model.getColDefs();
            int index = 0;
            for (BnColumn colDef : colDefs) {
                if (path.equals((Object)colDef.getPath())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
    }
}

