/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.table;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.beanfabrics.event.ElementChangedEvent;
import org.beanfabrics.event.ElementsAddedEvent;
import org.beanfabrics.event.ElementsDeselectedEvent;
import org.beanfabrics.event.ElementsRemovedEvent;
import org.beanfabrics.event.ElementsReplacedEvent;
import org.beanfabrics.event.ElementsSelectedEvent;
import org.beanfabrics.event.ListListener;
import org.beanfabrics.event.WeakListListener;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.util.Interval;

class DelegatingBnTableSelectionModel
implements ListSelectionModel {
    private ListSelectionModel delegate = new DefaultListSelectionModel();
    private IListPM<? extends PresentationModel> list;
    private final ListSelectionListener delegateListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            DelegatingBnTableSelectionModel.this.fireValueChanged(e.getFirstIndex(), e.getLastIndex() - e.getFirstIndex() + 1, e.getValueIsAdjusting());
        }
    };
    private final ListListener listener = new WeakListListener(){

        public void elementsDeselected(ElementsDeselectedEvent evt) {
            DelegatingBnTableSelectionModel.this.delegate.removeSelectionInterval(evt.getBeginIndex(), evt.getBeginIndex() + evt.getLength() - 1);
        }

        public void elementsSelected(ElementsSelectedEvent evt) {
            DelegatingBnTableSelectionModel.this.delegate.addSelectionInterval(evt.getBeginIndex(), evt.getBeginIndex() + evt.getLength() - 1);
        }

        public void elementChanged(ElementChangedEvent evt) {
        }

        public void elementsAdded(ElementsAddedEvent evt) {
        }

        public void elementsRemoved(ElementsRemovedEvent evt) {
        }

        public void elementsReplaced(ElementsReplacedEvent evt) {
        }
    };
    private final CopyOnWriteArrayList<ListSelectionListener> eventListeners = new CopyOnWriteArrayList();

    public DelegatingBnTableSelectionModel(IListPM<? extends PresentationModel> pModel) {
        Interval[] intervals;
        if (pModel == null) {
            throw new IllegalArgumentException("pModel must not be null");
        }
        this.list = pModel;
        int[] indexes = this.list.getSelection().getIndexes();
        for (Interval interval : intervals = Interval.createIntervals((int[])indexes)) {
            this.delegate.addSelectionInterval(interval.startIndex, interval.endIndex);
        }
        this.list.addListListener(this.listener);
        this.delegate.addListSelectionListener(this.delegateListener);
    }

    public void dismiss() {
        this.list.removeListListener(this.listener);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener l) {
        if (l == null) {
            throw new IllegalArgumentException("l must not be null.");
        }
        this.eventListeners.add(l);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener l) {
        if (l == null) {
            throw new IllegalArgumentException("l must not be null.");
        }
        this.eventListeners.remove(l);
    }

    protected void fireValueChangedBetween(int index0, int index1, boolean valueIsAdjusting) {
        int beginIndex = Math.min(index0, index1);
        int endIndex = Math.max(index0, index1);
        int len = endIndex - beginIndex;
        this.fireValueChanged(beginIndex, len, valueIsAdjusting);
    }

    protected void fireValueChanged(int beginIndex, int length, boolean valueIsAdjusting) {
        if (this.eventListeners.isEmpty()) {
            return;
        }
        ListSelectionEvent evt = new ListSelectionEvent(this, beginIndex, beginIndex + length - 1, valueIsAdjusting);
        for (ListSelectionListener l : this.eventListeners) {
            l.valueChanged(evt);
        }
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        System.out.println("BnTableSelectionModel.addSelectionInterval()");
        this.delegate.addSelectionInterval(index0, index1);
        int beginIndex = Math.min(index0, index1);
        int endIndex = Math.max(index0, index1);
        this.list.getSelection().addInterval(beginIndex, endIndex);
    }

    @Override
    public void clearSelection() {
        this.delegate.clearSelection();
        this.list.getSelection().clear();
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.delegate.getAnchorSelectionIndex();
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.delegate.getLeadSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.delegate.getMaxSelectionIndex();
    }

    @Override
    public int getMinSelectionIndex() {
        return this.delegate.getMinSelectionIndex();
    }

    @Override
    public int getSelectionMode() {
        return this.delegate.getSelectionMode();
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.delegate.getValueIsAdjusting();
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        System.out.println("BnTableSelectionModel.insertIndexInterval()");
        this.delegate.insertIndexInterval(index, length, before);
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.delegate.isSelectedIndex(index);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.delegate.isSelectionEmpty();
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        this.delegate.removeIndexInterval(index0, index1);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        this.delegate.removeSelectionInterval(index0, index1);
        int beginIndex = Math.min(index0, index1);
        int endIndex = Math.max(index0, index1);
        this.list.getSelection().removeInterval(beginIndex, endIndex);
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this.delegate.setAnchorSelectionIndex(index);
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        this.delegate.setLeadSelectionIndex(index);
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        System.out.println("BnTableSelectionModel.setSelectionInterval()");
        this.delegate.setSelectionInterval(index0, index1);
        int beginIndex = Math.min(index0, index1);
        int endIndex = Math.max(index0, index1);
        this.list.getSelection().setInterval(beginIndex, endIndex);
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.delegate.setSelectionMode(selectionMode);
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.delegate.setValueIsAdjusting(valueIsAdjusting);
    }
}

