/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.list;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.beanfabrics.Path;
import org.beanfabrics.swing.list.CellConfig;
import org.beanfabrics.util.ExceptionUtil;

public class CellConfigPropertyEditor
implements PropertyEditor {
    private static final String CELL_CONFIG_CLASSNAME = CellConfig.class.getName();
    private static final String PATH_CLASSNAME = Path.class.getName();
    private CellConfig value;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    @Override
    public void setValue(Object aValue) {
        CellConfig newValue;
        CellConfig oldValue = this.value;
        this.value = newValue = (CellConfig)aValue;
        this.support.firePropertyChange(null, null, null);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public String getJavaInitializationString() {
        try {
            if (this.value == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("new " + CELL_CONFIG_CLASSNAME + "(");
            sb.append(" new " + PATH_CLASSNAME + "(\"").append(this.value.getPath().getPathString() + "\")");
            sb.append(" )");
            return sb.toString();
        }
        catch (Exception ex) {
            ExceptionUtil.getInstance().handleException("Can't call getJavaInitializationString ", (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getAsText() {
        try {
            if (this.value == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(Path.getPathString((Path)this.value.getPath()));
            sb.append("]");
            return sb.toString();
        }
        catch (Exception ex) {
            ExceptionUtil.getInstance().handleException("Can't call getAsText ", (Throwable)ex);
            return "";
        }
    }

    @Override
    public void setAsText(String text) {
        try {
            CellConfig newValue;
            CellConfig oldValue = this.value;
            if (text == null || text.trim().length() == 0) {
                newValue = null;
            } else {
                int braceStart = text.indexOf("[");
                int braceEnd = text.indexOf("]");
                newValue = this.scan(text.substring(braceStart + 1, braceEnd));
            }
            this.setValue(newValue);
        }
        catch (Exception e) {
            ExceptionUtil.getInstance().handleException("Can't call setAsText with param '" + text + "'", (Throwable)e);
        }
    }

    private CellConfig scan(String text) throws IllegalArgumentException {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        return new CellConfig(new Path(text));
    }
}

