/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.path;

import java.net.URL;
import java.util.ResourceBundle;
import org.beanfabrics.Path;
import org.beanfabrics.meta.PathNode;
import org.beanfabrics.meta.TypeInfo;
import org.beanfabrics.model.AbstractPM;
import org.beanfabrics.model.IconTextPM;
import org.beanfabrics.model.MapPM;
import org.beanfabrics.model.OperationPM;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.model.TextPM;
import org.beanfabrics.support.OnChange;
import org.beanfabrics.support.Operation;
import org.beanfabrics.support.SortOrder;
import org.beanfabrics.support.Validation;
import org.beanfabrics.swing.customizer.path.PathContext;
import org.beanfabrics.swing.customizer.path.PathNodePM;
import org.beanfabrics.util.ResourceBundleFactory;
import org.beanfabrics.validation.ValidationState;

public class PathBrowserPM
extends AbstractPM {
    protected static final String KEY_MESSAGE_INVALID_PATH = "message.invalidPath";
    private final ResourceBundle resourceBundle = ResourceBundleFactory.getBundle(PathBrowserPM.class);
    private static final URL SUCCESS_ICON = PathBrowserPM.class.getResource("agt_action_success.png");
    private static final URL FAIL_ICON = PathBrowserPM.class.getResource("agt_action_fail.png");
    private static final URL WARNING_ICON = PathBrowserPM.class.getResource("messagebox_warning.png");
    TextPM currentSelectedPath = new TextPM();
    TextPM currentSelectedType = new TextPM();
    MapPM<PathNode, PathNodePM> children = new MapPM();
    OperationPM gotoSelectedChild = new OperationPM();
    OperationPM gotoCurrentPath = new OperationPM();
    OperationPM gotoParent = new OperationPM();
    IconTextPM status = new IconTextPM();
    private PathNode rootElement;
    private PathNode currentElement;
    private TypeInfo requiredModelTypeInfo;

    public PathBrowserPM() {
        PMManager.setup((PresentationModel)this);
        this.currentSelectedType.setEditable(false);
        this.status.setEditable(false);
        this.updateStatus();
    }

    public void setPathContext(PathContext pathContext) {
        if (pathContext == null) {
            throw new IllegalArgumentException("pathContext==null");
        }
        this.rootElement = pathContext.root;
        this.requiredModelTypeInfo = pathContext.requiredModelTypeInfo;
    }

    public void setCurrentPath(Path path) {
        PathNode pathElementInfo;
        this.currentSelectedPath.setText(Path.getPathString((Path)path));
        PathNode pathNode = pathElementInfo = this.rootElement == null ? null : this.rootElement.getNode(path);
        if (pathElementInfo == null) {
            this.loadChildren(null);
        } else {
            this.loadChildren(pathElementInfo.getParent());
            this.selectChild(pathElementInfo);
        }
    }

    public Path getCurrentPath() {
        if (this.currentSelectedPath.isEmpty()) {
            return null;
        }
        Path path = Path.parse((String)this.currentSelectedPath.getText());
        return path;
    }

    private void loadChildren(PathNode aElement) {
        this.currentElement = aElement;
        Path currentPath = this.getCurrentPath();
        this.children.clear();
        if (aElement == null) {
            this.gotoParent.setDescription("");
            PathNodePM rootCell = new PathNodePM();
            rootCell.setData(this.rootElement);
            this.children.put((Object)this.rootElement, (PresentationModel)rootCell);
            if (this.rootElement.getPath().equals((Object)currentPath)) {
                this.children.getSelectedKeys().add((Object)this.rootElement);
            }
        } else {
            this.gotoParent.setDescription("Up to " + this.currentElement.getTypeInfo().getJavaType().getSimpleName());
            for (PathNode child : aElement.getChildren()) {
                PathNodePM cell = new PathNodePM();
                cell.setData(child);
                this.children.put((Object)child, (PresentationModel)cell);
                if (!child.getPath().equals((Object)currentPath)) continue;
                this.children.getSelectedKeys().add((Object)child);
            }
        }
    }

    public TypeInfo getCurrentModelTypeInfo() {
        PathNode element;
        Path path = this.getCurrentPath();
        if (path != null && this.rootElement != null && (element = this.rootElement.getNode(path)) != null) {
            return element.getTypeInfo();
        }
        return null;
    }

    @OnChange(path={"children"})
    void updateCurrentPath() {
        PathNodePM first;
        if (!this.children.getSelection().isEmpty() && (first = (PathNodePM)this.children.getSelection().getFirst()) != null) {
            String pathStr = Path.getPathString((Path)first.getData().getPath());
            this.currentSelectedPath.setText(pathStr);
        }
    }

    @OnChange(path={"currentSelectedPath"})
    void updateStatus() {
        if (this.currentSelectedPath.isEmpty()) {
            String txt = "Enter a valid path here.";
            if (this.requiredModelTypeInfo != null) {
                txt = txt + " A path is valid if it points to an PresentationModel of type " + this.requiredModelTypeInfo.getName();
            }
            this.status.setText("<html>" + txt + "</html>");
            this.status.setIconUrl(WARNING_ICON);
        } else {
            ValidationState vState = this.currentSelectedPath.getValidationState();
            this.status.setText(vState == null ? null : "<html>" + vState.getMessage() + "</html>");
            this.status.setIconUrl(vState == null ? SUCCESS_ICON : FAIL_ICON);
        }
    }

    @OnChange(path={"currentSelectedPath"})
    void updateNodeType() {
        TypeInfo desc = this.getCurrentModelTypeInfo();
        if (desc == null) {
            this.currentSelectedType.setText(null);
            this.currentSelectedType.setDescription("Unknown type");
        } else {
            String classname = desc.getName();
            this.currentSelectedType.setText(PathBrowserPM.getBasename(classname));
            this.currentSelectedType.setDescription(classname);
        }
    }

    @Validation(path={"currentSelectedPath"}, message="This path can not be resolved")
    @SortOrder(value=1)
    boolean canPathBeResolved() {
        Path path = Path.parse((String)this.currentSelectedPath.getText());
        return this.rootElement != null && this.rootElement.getNode(path) != null;
    }

    @Validation(path={"currentSelectedPath"})
    @SortOrder(value=2)
    ValidationState matchesRequiredModelTypeInfo() {
        if (this.requiredModelTypeInfo != null) {
            boolean valid;
            TypeInfo currentModelTypeInfo = this.getCurrentModelTypeInfo();
            boolean bl = valid = currentModelTypeInfo != null && this.requiredModelTypeInfo.isAssignableFrom(currentModelTypeInfo);
            if (!valid) {
                String message = String.format(this.resourceBundle.getString(KEY_MESSAGE_INVALID_PATH), this.requiredModelTypeInfo.getName());
                return new ValidationState(message);
            }
        }
        return null;
    }

    @Validation
    public boolean isPathValid() {
        return this.currentSelectedPath.isValid();
    }

    @Validation(path={"gotoSelectedChild"}, message="the selected model has no children")
    public boolean canGotoSelectedChild() {
        PathNode nextPathNode;
        PathNodePM first = (PathNodePM)this.children.getSelection().getFirst();
        return first != null && (nextPathNode = first.getData()).hasChildren();
    }

    @Operation
    public void gotoSelectedChild() {
        PathNode nextElement;
        PathNodePM cell = (PathNodePM)this.children.getSelection().getFirst();
        if (cell != null && (nextElement = cell.getData()).hasChildren()) {
            this.loadChildren(nextElement);
        }
    }

    @Validation(path={"gotoParent"}, message="Already on top")
    public boolean canGotoParent() {
        return this.currentElement != null;
    }

    @Operation
    public void gotoParent() {
        if (this.currentElement == null) {
            return;
        }
        PathNode nextSelectedChild = this.currentElement;
        PathNode nextElement = this.currentElement.getParent();
        this.loadChildren(nextElement);
        this.selectChild(nextSelectedChild);
    }

    private void selectChild(PathNode child) {
        if (this.children.containsKey((Object)child)) {
            this.children.getSelectedKeys().clear();
            this.children.getSelectedKeys().add((Object)child);
        }
    }

    @Operation
    public void gotoCurrentPath() {
        Path pathToChild;
        PathNode childPathInfo;
        if (this.rootElement != null && (childPathInfo = this.rootElement.getNode(pathToChild = this.getCurrentPath())) != null) {
            this.setCurrentPath(childPathInfo.getPath());
        }
    }

    private static String getBasename(String classname) {
        int idx = classname.lastIndexOf(36);
        if (idx == -1) {
            idx = classname.lastIndexOf(46);
        }
        if (idx == -1) {
            return classname;
        }
        return classname.substring(idx + 1);
    }
}

