/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.table;

import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.beanfabrics.Path;
import org.beanfabrics.meta.PathNode;
import org.beanfabrics.model.ListPM;
import org.beanfabrics.model.OperationPM;
import org.beanfabrics.model.PMManager;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.support.Operation;
import org.beanfabrics.support.Validation;
import org.beanfabrics.swing.customizer.path.PathChooserController;
import org.beanfabrics.swing.customizer.path.PathChooserPM;
import org.beanfabrics.swing.customizer.path.PathContext;
import org.beanfabrics.swing.customizer.table.ColumnPM;
import org.beanfabrics.swing.customizer.util.CustomizerUtil;
import org.beanfabrics.swing.table.BnColumn;
import org.beanfabrics.util.ResourceBundleFactory;
import org.beanfabrics.validation.ValidationState;

public class ColumnListPM<PM extends ColumnPM>
extends ListPM<PM> {
    protected static final String KEY_MESSAGE_SELECT_TO_MOVE_UP = "message.selectToMoveUp";
    protected static final String KEY_MESSAGE_SELECT_TO_MOVE_DOWN = "message.selectToMoveDown";
    protected static final String KEY_MESSAGE_ALREADY_AT_TOP = "message.alreadyAtTop";
    protected static final String KEY_MESSAGE_ALREADY_AT_BOTTOM = "message.alreadyAtBottom";
    private final ResourceBundle resourceBundle = ResourceBundleFactory.getBundle(ColumnListPM.class);
    protected final OperationPM addColumn = new OperationPM();
    protected final OperationPM removeColumns = new OperationPM();
    protected final OperationPM moveUp = new OperationPM();
    protected final OperationPM moveDown = new OperationPM();
    private PathNode rowPmRootNode;

    public ColumnListPM() {
        PMManager.setup((PresentationModel)this);
    }

    public void setRowPmRootNode(PathNode rowPmRootNode) {
        this.rowPmRootNode = rowPmRootNode;
        this.revalidateProperties();
    }

    public PathNode getRowPmRootNode() {
        return this.rowPmRootNode;
    }

    public void setData(BnColumn[] columns) {
        this.clear();
        for (BnColumn col : columns) {
            PM row = this.createRowPM();
            ((ColumnPM)((Object)row)).setData(col);
            this.add((PresentationModel)row);
        }
        this.revalidateProperties();
    }

    protected PM createRowPM() {
        ColumnPM result = new ColumnPM(this.rowPmRootNode);
        return (PM)((Object)result);
    }

    public BnColumn[] getData() {
        BnColumn[] result = new BnColumn[this.size()];
        int i = 0;
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            ColumnPM row = (ColumnPM)((Object)i$.next());
            result[i] = row.getData();
            ++i;
        }
        return result;
    }

    @Operation
    public void addColumn() {
        final PathChooserController ctrl = CustomizerUtil.createPathChooser(this.getContext(), new PathContext(this.rowPmRootNode, null), new Path());
        ctrl.getPresentationModel().onApply(new PathChooserPM.OnApplyHandler(){

            @Override
            public void apply() {
                ColumnListPM.this.addColumun(ctrl.getPresentationModel().getData());
            }
        });
        ctrl.getView().setVisible(true);
    }

    @Validation(path={"addColumn"}, message="Unknown element type")
    boolean canAddColumn() {
        return this.rowPmRootNode != null;
    }

    private void addColumun(Path path) {
        PM newRow = this.createRowPM();
        ((ColumnPM)((Object)newRow)).setData(new BnColumn(path, this.createDefaultHeader(path)));
        this.add((PresentationModel)newRow);
    }

    private String createDefaultHeader(Path path) {
        if (path == null) {
            return "new header";
        }
        String lastElement = path.getLastElement();
        if (lastElement == null) {
            return "new header";
        }
        if (lastElement.length() > 1) {
            String result = Character.toUpperCase(lastElement.charAt(0)) + lastElement.substring(1);
            return result;
        }
        return lastElement;
    }

    @Operation
    public void removeColumns() {
        this.removeAll((Collection)this.getSelection());
    }

    @Operation
    public void moveUp() {
        this.moveUp.check();
        int index = this.getSelection().getMinIndex();
        this.swap(index, index - 1);
    }

    @Validation(path={"moveUp"})
    ValidationState validateMoveUp() {
        if (this.getSelection().size() != 1) {
            String message = this.resourceBundle.getString(KEY_MESSAGE_SELECT_TO_MOVE_UP);
            return new ValidationState(message);
        }
        int index = this.getSelection().getMinIndex();
        if (index == 0) {
            String message = this.resourceBundle.getString(KEY_MESSAGE_ALREADY_AT_TOP);
            return new ValidationState(message);
        }
        return null;
    }

    @Operation
    public void moveDown() {
        this.moveDown.check();
        int index = this.getSelection().getMinIndex();
        this.swap(index, index + 1);
    }

    @Validation(path={"moveDown"})
    public ValidationState validateMoveDown() {
        if (this.getSelection().size() != 1) {
            String message = this.resourceBundle.getString(KEY_MESSAGE_SELECT_TO_MOVE_DOWN);
            return new ValidationState(message);
        }
        int index = this.getSelection().getMinIndex();
        if (index == this.size() - 1) {
            String message = this.resourceBundle.getString(KEY_MESSAGE_ALREADY_AT_BOTTOM);
            return new ValidationState(message);
        }
        return null;
    }
}

