/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.BnButton;
import org.beanfabrics.swing.customizer.table.ColumnListPM;
import org.beanfabrics.swing.customizer.util.RowNumberTable;
import org.beanfabrics.swing.table.BnColumnBuilder;
import org.beanfabrics.swing.table.BnTable;

public class ColumnListPanel
extends JPanel
implements View<ColumnListPM>,
ModelSubscriber {
    private BnButton moveDownButton;
    private BnButton moveUpButton;
    private BnButton removeButton;
    private BnButton addButton;
    private JPanel buttonPanel;
    protected BnTable bnTable;
    private JScrollPane scrollPane;
    private JPanel panel;
    private final Link link = new Link((View)this);
    private ModelProvider localProvider;

    public ColumnListPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanel(), "Center");
    }

    protected ModelProvider getLocalProvider() {
        if (this.localProvider == null) {
            this.localProvider = new ModelProvider();
            this.localProvider.setPresentationModelType(ColumnListPM.class);
        }
        return this.localProvider;
    }

    public ColumnListPM getPresentationModel() {
        return (ColumnListPM)this.getLocalProvider().getPresentationModel();
    }

    public void setPresentationModel(ColumnListPM pModel) {
        this.getLocalProvider().setPresentationModel((PresentationModel)pModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.getScrollPane(), "Center");
            this.panel.add((Component)this.getButtonPanel(), "East");
            this.panel.setOpaque(false);
        }
        return this.panel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getBnTable());
            this.scrollPane.getViewport().setBackground(this.getBnTable().getBackground());
            RowNumberTable rowTable = new RowNumberTable(this.getBnTable());
            rowTable.setPreferredRowHeaderWidth(30);
            this.scrollPane.setRowHeaderView(rowTable);
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", rowTable.getTableHeader());
            JPanel corner = new JPanel();
            corner.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.scrollPane.setCorner("LOWER_LEFT_CORNER", corner);
        }
        return this.scrollPane;
    }

    private BnTable getBnTable() {
        if (this.bnTable == null) {
            this.bnTable = new BnTable();
            this.defineTableColumns();
            this.bnTable.setPath(new Path("this"));
            this.bnTable.setModelProvider((IModelProvider)this.getLocalProvider());
            this.bnTable.setBackground(Color.white);
            this.bnTable.setGridColor(Color.white);
            this.bnTable.setIntercellSpacing(new Dimension(0, 0));
        }
        return this.bnTable;
    }

    protected void defineTableColumns() {
        this.bnTable.setColumns(new BnColumnBuilder().addColumn().withPath("this.path").withName("path").withWidth(120).withOperationPath("this.path.choosePath").addColumn().withPath("this.columnName").withName("columnName").withWidthFixed(true).addColumn().withPath("this.width").withName("width").withWidth(55).withWidthFixed(true).addColumn().withPath("this.fixedWidth").withName("fixedWidth").withWidth(45).withWidthFixed(true).addColumn().withPath("this.alignment").withName("alignment").withWidth(45).withWidthFixed(true).addColumn().withPath("this.operationPath").withName("operationPath").withWidth(120).withWidthFixed(true).withOperationPath("this.operationPath.choosePath").build());
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.rowHeights = new int[]{0, 7, 7, 7, 7};
            this.buttonPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.buttonPanel.add((Component)this.getAddButton(), gridBagConstraints);
            GridBagConstraints gridBagConstraints_1 = new GridBagConstraints();
            gridBagConstraints_1.fill = 2;
            gridBagConstraints_1.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints_1.gridy = 1;
            gridBagConstraints_1.gridx = 0;
            this.buttonPanel.add((Component)this.getRemoveButton(), gridBagConstraints_1);
            this.buttonPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints_3 = new GridBagConstraints();
            gridBagConstraints_3.fill = 2;
            gridBagConstraints_3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints_3.gridy = 2;
            gridBagConstraints_3.gridx = 0;
            this.buttonPanel.add((Component)this.getMoveUpButton(), gridBagConstraints_3);
            GridBagConstraints gridBagConstraints_4 = new GridBagConstraints();
            gridBagConstraints_4.fill = 2;
            gridBagConstraints_4.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints_4.gridy = 3;
            gridBagConstraints_4.gridx = 0;
            this.buttonPanel.add((Component)this.getMoveDownButton(), gridBagConstraints_4);
        }
        return this.buttonPanel;
    }

    private BnButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new BnButton();
            this.addButton.setPath(new Path("this.addColumn"));
            this.addButton.setModelProvider((IModelProvider)this.getLocalProvider());
            this.addButton.setText("Add ...");
            ColumnListPanel.setTexturedButtonType(this.addButton);
        }
        return this.addButton;
    }

    private BnButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new BnButton();
            this.removeButton.setPath(new Path("this.removeColumns"));
            this.removeButton.setModelProvider((IModelProvider)this.getLocalProvider());
            this.removeButton.setText("Remove");
            ColumnListPanel.setTexturedButtonType(this.removeButton);
        }
        return this.removeButton;
    }

    protected BnButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new BnButton();
            this.moveUpButton.setPath(new Path("this.moveUp"));
            this.moveUpButton.setModelProvider((IModelProvider)this.getLocalProvider());
            this.moveUpButton.setText("Up");
            ColumnListPanel.setTexturedButtonType(this.moveUpButton);
        }
        return this.moveUpButton;
    }

    protected BnButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new BnButton();
            this.moveDownButton.setPath(new Path("this.moveDown"));
            this.moveDownButton.setModelProvider((IModelProvider)this.getLocalProvider());
            this.moveDownButton.setText("Down");
            ColumnListPanel.setTexturedButtonType(this.moveDownButton);
        }
        return this.moveDownButton;
    }

    private static void setTexturedButtonType(AbstractButton button) {
        button.putClientProperty("JButton.buttonType", "gradient");
    }
}

