/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.cdi.spring.context;

import java.io.Serializable;
import java.util.Map;
import org.beangle.cdi.spring.context.BeanFactoryRefreshedEvent;
import org.beangle.cdi.spring.context.ContextLoader;
import org.beangle.commons.event.DefaultEventMulticaster;
import org.beangle.commons.event.Event;
import org.beangle.commons.event.EventMulticaster;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.reflect.Reflections$;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.slf4j.Logger;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.support.ResourceEditorRegistrar;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.xml.sax.EntityResolver;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class BeanFactoryLoader
extends DefaultResourceLoader
implements ResourcePatternResolver,
ContextLoader,
Logging {
    private Logger logger;
    private StandardEnvironment environment;
    private EventMulticaster eventMulticaster;
    private ResourcePatternResolver resourcePatternResolver;
    private ClassLoader classLoader;
    private BeanFactory result;

    public BeanFactoryLoader() {
        Logging.$init$((Logging)this);
        this.environment = new StandardEnvironment();
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
        this.classLoader = ClassUtils.getDefaultClassLoader();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public StandardEnvironment environment() {
        return this.environment;
    }

    public void environment_$eq(StandardEnvironment x$1) {
        this.environment = x$1;
    }

    public EventMulticaster eventMulticaster() {
        return this.eventMulticaster;
    }

    public void eventMulticaster_$eq(EventMulticaster x$1) {
        this.eventMulticaster = x$1;
    }

    public ResourcePatternResolver resourcePatternResolver() {
        return this.resourcePatternResolver;
    }

    public void resourcePatternResolver_$eq(ResourcePatternResolver x$1) {
        this.resourcePatternResolver = x$1;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public void classLoader_$eq(ClassLoader x$1) {
        this.classLoader = x$1;
    }

    public BeanFactory result() {
        return this.result;
    }

    public void result_$eq(BeanFactory x$1) {
        this.result = x$1;
    }

    @Override
    public BeanFactory load(String id, String contextClassName, String configLocation, BeanFactory parent) {
        Stopwatch watch = new Stopwatch(true);
        Logger$.MODULE$.info$extension(this.logger(), () -> BeanFactoryLoader.load$$anonfun$1(id));
        DefaultListableBeanFactory result = contextClassName == null ? new DefaultListableBeanFactory() : (DefaultListableBeanFactory)Reflections$.MODULE$.newInstance(ClassLoaders$.MODULE$.load(contextClassName, ClassLoaders$.MODULE$.load$default$2()));
        result.setAllowBeanDefinitionOverriding(false);
        result.setSerializationId(id);
        result.setParentBeanFactory(parent);
        this.loadBeanDefinitions(result, this.environment().resolveRequiredPlaceholders(configLocation));
        this.refresh(result);
        Logger$.MODULE$.info$extension(this.logger(), () -> BeanFactoryLoader.load$$anonfun$2(id, watch));
        return result;
    }

    public void loadBeanDefinitions(DefaultListableBeanFactory beanFactory, String configLocation) {
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        reader.setEnvironment((Environment)this.environment());
        reader.setResourceLoader((ResourceLoader)this);
        reader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this));
        reader.setValidating(false);
        reader.loadBeanDefinitions(configLocation);
    }

    public void refresh(DefaultListableBeanFactory beanFactory) {
        this.prepareBeanFactory((ConfigurableListableBeanFactory)beanFactory);
        this.invokeBeanFactoryPostProcessors(beanFactory);
        this.initApplicationEventMulticaster((ConfigurableListableBeanFactory)beanFactory);
        this.finishBeanFactoryInitialization((ConfigurableListableBeanFactory)beanFactory);
        this.eventMulticaster().multicast((Event)new BeanFactoryRefreshedEvent((BeanFactory)beanFactory));
    }

    public void initApplicationEventMulticaster(ConfigurableListableBeanFactory beanFactory) {
        Map multicasters = beanFactory.getBeansOfType(EventMulticaster.class);
        if (multicasters.isEmpty()) {
            this.eventMulticaster_$eq((EventMulticaster)new DefaultEventMulticaster());
        } else {
            this.eventMulticaster_$eq((EventMulticaster)multicasters.values().iterator().next());
        }
    }

    public void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.setBeanClassLoader(this.classLoader());
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)new ResourceEditorRegistrar((ResourceLoader)this, (PropertyResolver)this.environment()));
        beanFactory.registerResolvableDependency(BeanFactory.class, (Object)beanFactory);
        if (!beanFactory.containsLocalBean("environment")) {
            beanFactory.registerSingleton("environment", (Object)this.environment());
        }
        if (!beanFactory.containsLocalBean("systemProperties")) {
            beanFactory.registerSingleton("systemProperties", (Object)this.environment().getSystemProperties());
        }
        if (!beanFactory.containsLocalBean("systemEnvironment")) {
            beanFactory.registerSingleton("systemEnvironment", (Object)this.environment().getSystemEnvironment());
        }
    }

    public void invokeBeanFactoryPostProcessors(DefaultListableBeanFactory beanFactory) {
        Object[] postProcessorNames = beanFactory.getBeanNamesForType(BeanDefinitionRegistryPostProcessor.class, true, false);
        Object object = Predef$.MODULE$.refArrayOps(postProcessorNames);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)name -> {
            BeanDefinitionRegistryPostProcessor pp = (BeanDefinitionRegistryPostProcessor)beanFactory.getBean(name, BeanDefinitionRegistryPostProcessor.class);
            pp.postProcessBeanDefinitionRegistry((BeanDefinitionRegistry)beanFactory);
            pp.postProcessBeanFactory((ConfigurableListableBeanFactory)beanFactory);
        });
    }

    public void finishBeanFactoryInitialization(ConfigurableListableBeanFactory beanFactory) {
        String conversionServiceBeanName = "conversionService";
        if (beanFactory.containsBean(conversionServiceBeanName) && beanFactory.isTypeMatch(conversionServiceBeanName, ConversionService.class)) {
            beanFactory.setConversionService((ConversionService)beanFactory.getBean(conversionServiceBeanName, ConversionService.class));
        }
        beanFactory.setTempClassLoader(null);
        beanFactory.freezeConfiguration();
        beanFactory.preInstantiateSingletons();
    }

    public Resource[] getResources(String locationPattern) {
        return this.resourcePatternResolver().getResources(locationPattern);
    }

    @Override
    public void close() {
    }

    private static final String load$$anonfun$1(String id$1) {
        return "" + id$1 + " starting";
    }

    private static final String load$$anonfun$2(String id$2, Stopwatch watch$1) {
        return "" + id$2 + " started in " + watch$1;
    }
}

