/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.cdi.spring.context;

import java.net.URL;
import org.beangle.cdi.bind.BindRegistry$;
import org.beangle.cdi.spring.context.ContextLoader;
import org.beangle.cdi.spring.context.XmlWebApplicationContext;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.reflect.Reflections$;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.runtime.Statics;

public class ApplicationContextLoader
implements ContextLoader,
Logging {
    private Logger logger;
    private ConfigurableApplicationContext result;

    public ApplicationContextLoader() {
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public ConfigurableApplicationContext result() {
        return this.result;
    }

    public void result_$eq(ConfigurableApplicationContext x$1) {
        this.result = x$1;
    }

    private Class<?> determineContextClass(String ctxClassName) {
        if (ctxClassName != null) {
            return ClassLoaders$.MODULE$.load(ctxClassName, ClassLoaders$.MODULE$.load$default$2());
        }
        Option option = ClassLoaders$.MODULE$.getResource("org/springframework/web/context/ContextLoader.properties", ClassLoaders$.MODULE$.getResource$default$2());
        if (option instanceof Some) {
            URL propUrl = (URL)((Some)option).value();
            Map properties = IOs$.MODULE$.readJavaProperties(propUrl);
            return ClassLoaders$.MODULE$.load((String)properties.apply((Object)"org.springframework.web.context.WebApplicationContext"), ClassLoaders$.MODULE$.load$default$2());
        }
        if (None$.MODULE$.equals(option)) {
            return XmlWebApplicationContext.class;
        }
        throw new MatchError((Object)option);
    }

    public ApplicationContext load(String id, String contextClassName, String configLocation, String reconfigLocation, BeanFactory parent) {
        Class<?> contextClass = this.determineContextClass(contextClassName);
        Predef$.MODULE$.require(ConfigurableApplicationContext.class.isAssignableFrom(contextClass));
        Stopwatch watch = new Stopwatch(true);
        Logger$.MODULE$.info$extension(this.logger(), () -> ApplicationContextLoader.load$$anonfun$1(id));
        this.result_$eq((ConfigurableApplicationContext)Reflections$.MODULE$.newInstance(contextClass));
        ConfigurableApplicationContext configurableApplicationContext = this.result();
        if (configurableApplicationContext instanceof AbstractRefreshableApplicationContext) {
            AbstractRefreshableApplicationContext ara = (AbstractRefreshableApplicationContext)configurableApplicationContext;
            ara.setAllowBeanDefinitionOverriding(false);
        }
        this.result().setId(id);
        BindRegistry$.MODULE$.reconfigUrl_$eq(Strings$.MODULE$.isNotBlank((CharSequence)reconfigLocation) ? reconfigLocation : "");
        this.result().setParent((ApplicationContext)parent);
        ((AbstractRefreshableConfigApplicationContext)this.result()).setConfigLocation(configLocation);
        this.result().refresh();
        Logger$.MODULE$.info$extension(this.logger(), () -> ApplicationContextLoader.load$$anonfun$2(id, watch));
        return this.result();
    }

    @Override
    public void close() {
        this.result().close();
    }

    private static final String load$$anonfun$1(String id$1) {
        return id$1 + " starting";
    }

    private static final String load$$anonfun$2(String id$2, Stopwatch watch$1) {
        return id$2 + " started in " + watch$1;
    }
}

