/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.http.agent;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.http.agent.Engine;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;

public enum BrowserCategory {
    Firefox("Firefox", Engine.Gecko, "Firefox/(\\S*)->$1", "Firefox"),
    Thunderbird("Thunderbird", Engine.Gecko, "Thunderbird/(\\S*)->$1", "Thunderbird"),
    Camino("Camino", Engine.Gecko, "Camino/(\\S*)->$1", "Camino"),
    Flock("Flock", Engine.Gecko, "Flock/(\\S*)->$1"),
    FirefoxMobile("Firefox Mobile", Engine.Gecko, "Firefox/3.5 Maemo->3"),
    SeaMonkey("SeaMonkey", Engine.Gecko, "SeaMonkey"),
    Tencent("Tencent Traveler", Engine.Trident, "TencentTraveler (\\S*);->$1"),
    Sogo("Sogo", Engine.Trident, "SE(.*)MetaSr"),
    TheWorld("The World", Engine.Trident, "theworld"),
    IE360("Internet Explorer 360", Engine.Trident, "360SE"),
    IeMobile("IE Mobile", Engine.Trident, "IEMobile (\\S*)->$1"),
    IE("Internet Explorer", Engine.Trident, "MSIE (\\S*);->$1", "MSIE"),
    OutlookExpress("Windows Live Mail", Engine.Trident, "Outlook-Express/7.0->7.0"),
    Maxthon("Maxthon", Engine.WebKit, "Maxthon/(\\S*)->$1", "Maxthon"),
    Chrome("Chrome", Engine.WebKit, "Chrome/(\\S*)->$1", "Chrome"),
    Safari("Safari", Engine.WebKit, "Version/(\\S*) Safari->$1", "Safari"),
    Omniweb("Omniweb", Engine.WebKit, "OmniWeb"),
    AppleMail("Apple Mail", Engine.WebKit, "AppleWebKit"),
    ChromeMobile("Chrome Mobile", Engine.WebKit, "CrMo/(\\S*)->$1"),
    SafariMobile("Mobile Safari", Engine.WebKit, "Mobile Safari", "Mobile/5A347 Safari", "Mobile/3A101a Safari", "Mobile/7B367 Safari"),
    Silk("Silk", Engine.WebKit, "Silk/(\\S*)->$1"),
    Dolfin("Samsung Dolphin", Engine.WebKit, "Dolfin/(\\S*)->$1"),
    Opera("Opera", Engine.Presto, "Opera/(.*?)Version/(\\S*)->$2", "Opera Mini->Mini", "Opera"),
    Konqueror("Konqueror", Engine.Khtml, "Konqueror"),
    Outlook("Outlook", Engine.Word, "MSOffice 12->2007", "MSOffice 14->2010", "MSOffice"),
    LotusNotes("Lotus Notes", Engine.Other, "Lotus-Notes"),
    Bot("Robot/Spider", Engine.Other, "Googlebot", "bot", "spider", "crawler", "Feedfetcher", "Slurp", "Twiceler", "Nutch", "BecomeBot"),
    Mozilla("Mozilla", Engine.Other, "Mozilla", "Moozilla"),
    CFNetwork("CFNetwork", Engine.Other, "CFNetwork"),
    Eudora("Eudora", Engine.Other, "Eudora", "EUDORA"),
    PocoMail("PocoMail", Engine.Other, "PocoMail"),
    TheBat("The Bat!", Engine.Other, "The Bat"),
    NetFront("NetFront", Engine.Other, "NetFront"),
    Evolution("Evolution", Engine.Other, "CamelHttpStream"),
    Lynx("Lynx", Engine.Other, "Lynx"),
    UC("UC", Engine.Other, "UCWEB"),
    Download("Downloading Tool", Engine.Other, "cURL", "wget"),
    Unknown("Unknown", Engine.Other, new String[0]);

    private final String name;
    private final Engine engine;
    private final List<Pair<Pattern, String>> versionPairs = CollectUtils.newArrayList();

    private BrowserCategory(String name, Engine renderEngine, String ... versions) {
        this.name = name;
        this.engine = renderEngine;
        this.engine.addCategory(this);
        String[] arr$ = versions;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String version;
            String matcheTarget = version = arr$[i$];
            String versionNum = "";
            if (Strings.contains((CharSequence)version, (CharSequence)"->")) {
                matcheTarget = "(?i)" + Strings.substringBefore((String)version, (String)"->");
                versionNum = Strings.substringAfter((String)version, (String)"->");
            }
            this.versionPairs.add((Pair<Pattern, String>)Pair.of((Object)Pattern.compile(matcheTarget), (Object)versionNum));
        }
    }

    public String getName() {
        return this.name;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public String match(String agentString) {
        for (Pair<Pattern, String> pair : this.versionPairs) {
            Matcher m = ((Pattern)pair.getKey()).matcher(agentString);
            if (!m.find()) continue;
            StringBuffer sb = new StringBuffer();
            m.appendReplacement(sb, (String)pair.getValue());
            sb.delete(0, m.start());
            return sb.toString();
        }
        return null;
    }
}

