/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.http.mime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.beangle.commons.inject.Resources;
import org.beangle.commons.lang.time.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeProvider {
    private static Logger logger = LoggerFactory.getLogger(MimeTypeProvider.class);
    private final Properties contentTypes = new Properties();
    private Resources resources;

    public String getMimeType(String ext, String defaultValue) {
        return this.contentTypes.getProperty(ext, defaultValue);
    }

    public String getMimeType(String ext) {
        return this.contentTypes.getProperty(ext);
    }

    private void loadMimeType(URL url) {
        try {
            Stopwatch watch = new Stopwatch(true);
            InputStream im = url.openStream();
            this.contentTypes.load(im);
            logger.info("Load {} content types in {}", (Object)this.contentTypes.size(), (Object)watch);
            im.close();
        }
        catch (IOException e) {
            logger.error("load " + url + " error", (Throwable)e);
        }
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
        if (null == resources) {
            return;
        }
        if (null != resources.getGlobal()) {
            this.loadMimeType(resources.getGlobal());
        }
        if (null != resources.getLocals()) {
            for (URL path : resources.getLocals()) {
                this.loadMimeType(path);
            }
        }
        if (null != resources.getUser()) {
            this.loadMimeType(resources.getUser());
        }
    }
}

