/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.access;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.event.Event;
import org.beangle.commons.event.EventListener;
import org.beangle.commons.web.access.AccessLogger;
import org.beangle.commons.web.access.AccessMonitor;
import org.beangle.commons.web.access.AccessRequest;
import org.beangle.commons.web.access.AccessRequestBuilder;
import org.beangle.commons.web.session.HttpSessionDestroyedEvent;

public class MemAccessMonitor
implements AccessMonitor,
EventListener<HttpSessionDestroyedEvent> {
    private AccessLogger logger;
    private AccessRequestBuilder builder;
    private Map<String, List<AccessRequest>> requests = CollectUtils.newConcurrentHashMap();

    @Override
    public AccessRequest begin(HttpServletRequest request) {
        AccessRequest r = this.builder.build(request);
        if (null != r) {
            List<AccessRequest> quene = this.requests.get(r.getSessionid());
            if (null == quene) {
                quene = Collections.synchronizedList(new LinkedList());
                this.requests.put(r.getSessionid(), quene);
            }
            quene.add(r);
        }
        return r;
    }

    @Override
    public void end(AccessRequest request, HttpServletResponse response) {
        if (null == request) {
            return;
        }
        List<AccessRequest> quene = this.requests.get(request.getSessionid());
        if (null != quene) {
            quene.remove(request);
        }
        request.setStatus(response.getStatus());
        if (null != this.logger) {
            request.setEndAt(System.currentTimeMillis());
            this.logger.log(request);
        }
    }

    @Override
    public List<AccessRequest> getRequests() {
        List result = CollectUtils.newArrayList((int)this.requests.size());
        for (List<AccessRequest> quene : this.requests.values()) {
            result.addAll(quene);
        }
        return result;
    }

    public void setLogger(AccessLogger logger) {
        this.logger = logger;
    }

    public void setBuilder(AccessRequestBuilder builder) {
        this.builder = builder;
    }

    public void onEvent(HttpSessionDestroyedEvent event) {
        this.requests.remove(event.getSession().getId());
    }

    public boolean supportsEventType(Class<? extends Event> eventType) {
        return HttpSessionDestroyedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }
}

