/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.filter;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.beangle.commons.bean.Disposable;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericHttpFilter
implements Filter,
Initializing,
Disposable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<String> requiredProperties = new HashSet<String>();
    private FilterConfig filterConfig;
    private ServletContext servletContext;

    public void init() throws Exception {
        this.initFilterBean();
    }

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        Assert.notNull((Object)filterConfig, (String)"FilterConfig must not be null", (Object[])new Object[0]);
        this.logger.debug("Initializing filter '{}'", (Object)filterConfig.getFilterName());
        this.filterConfig = filterConfig;
        this.initParams(filterConfig);
        this.initFilterBean();
        this.logger.debug("Filter '{}' configured successfully", (Object)filterConfig.getFilterName());
    }

    protected void initParams(FilterConfig config) throws ServletException {
        HashSet<String> missingProps = this.requiredProperties != null && !this.requiredProperties.isEmpty() ? new HashSet<String>(this.requiredProperties) : null;
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String property = (String)en.nextElement();
            String value = config.getInitParameter(property);
            try {
                PropertyUtils.setProperty((Object)this, (String)property, (Object)value);
            }
            catch (Exception e) {
                throw new ServletException("Set filter property'" + property + "' failed; the value is: " + value);
            }
            if (missingProps == null) continue;
            missingProps.remove(property);
        }
        if (missingProps != null && missingProps.size() > 0) {
            throw new ServletException("Initialization from FilterConfig for filter '" + config.getFilterName() + "' failed; the following required properties were missing: " + Strings.join(missingProps, (String)", "));
        }
    }

    public final FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected final String getFilterName() {
        return this.filterConfig != null ? this.filterConfig.getFilterName() : "None";
    }

    protected final ServletContext getServletContext() {
        return this.filterConfig != null ? this.filterConfig.getServletContext() : this.servletContext;
    }

    protected void initFilterBean() throws ServletException {
    }

    public void destroy() {
    }
}

