/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.resource;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.commons.io.ResourceLoader;
import org.beangle.commons.web.resource.PathResolver;
import org.beangle.commons.web.resource.ProcessChain;
import org.beangle.commons.web.resource.ProcessContext;
import org.beangle.commons.web.resource.ResourceFilter;

public class ResourceProcessor {
    private ResourceLoader loader = null;
    private PathResolver resolver = null;
    private List<ResourceFilter> filters = null;

    public void process(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<String> names = this.resolver.resolve(uri);
        List resources = this.loader.load(names);
        if (resources.size() != names.size()) {
            response.sendError(404);
            return;
        }
        ProcessContext pc = new ProcessContext(uri, names, resources);
        ProcessChain chain = new ProcessChain(this.filters.iterator());
        chain.process(pc, request, response);
        if (response.getStatus() == 200) {
            boolean isText = null != response.getContentType() && response.getContentType().startsWith("text/");
            for (ProcessContext.Resource res : pc.resources) {
                response.getOutputStream().write(res.data);
                if (!isText) continue;
                response.getOutputStream().write(10);
            }
        }
    }

    public void setLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    public void setResolver(PathResolver resolver) {
        this.resolver = resolver;
    }

    public void setFilters(List<ResourceFilter> filters) {
        this.filters = filters;
    }
}

