/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.resource.filter;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.commons.web.resource.ProcessChain;
import org.beangle.commons.web.resource.ProcessContext;
import org.beangle.commons.web.resource.ResourceFilter;

public class HeaderFilter
implements ResourceFilter {
    protected int expireDays = 7;

    @Override
    public void filter(ProcessContext context, HttpServletRequest request, HttpServletResponse response, ProcessChain chain) throws IOException {
        long maxLastModified = -1L;
        for (ProcessContext.Resource res : context.resources) {
            long lastModified = this.lastModified(res.url);
            if (lastModified <= maxLastModified) continue;
            maxLastModified = lastModified;
        }
        String requestETag = request.getHeader("If-None-Match");
        String newETag = String.valueOf(maxLastModified);
        response.setHeader("ETag", newETag);
        if (newETag.equals(requestETag)) {
            response.setStatus(304);
            return;
        }
        chain.process(context, request, response);
        Calendar cal = Calendar.getInstance();
        cal.add(5, this.expireDays);
        long expires = cal.getTimeInMillis();
        response.setDateHeader("Date", System.currentTimeMillis());
        response.setDateHeader("Expires", expires);
        response.setDateHeader("Retry-After", expires);
        response.setHeader("Cache-Control", "public");
        if (maxLastModified > 0L) {
            response.setDateHeader("Last-Modified", maxLastModified);
        }
    }

    private long lastModified(URL url) {
        if (url.getProtocol().equals("file")) {
            return new File(url.getFile()).lastModified();
        }
        try {
            URL jarURL;
            URLConnection conn = url.openConnection();
            if (conn instanceof JarURLConnection && (jarURL = ((JarURLConnection)conn).getJarFileURL()).getProtocol().equals("file")) {
                return new File(jarURL.getFile()).lastModified();
            }
        }
        catch (IOException e1) {
            return -1L;
        }
        return -1L;
    }

    public void setExpireDays(int expireDays) {
        this.expireDays = expireDays;
    }
}

