/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.resource.filter;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.commons.io.ResourceLoader;
import org.beangle.commons.lang.Charsets;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.Option;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.resource.ProcessChain;
import org.beangle.commons.web.resource.ProcessContext;
import org.beangle.commons.web.resource.ResourceFilter;

public class YUICompressFilter
implements ResourceFilter {
    private int lineBreak = 4000;
    private ResourceLoader loader = null;

    private boolean shouldFilter(HttpServletRequest request, HttpServletResponse response) {
        return (response.getContentType().equals("text/javascript") || response.getContentType().equals("text/css")) && !Objects.equals((Object)"no", (Object)request.getParameter("compress"));
    }

    @Override
    public void filter(ProcessContext context, HttpServletRequest request, HttpServletResponse response, ProcessChain chain) throws IOException {
        block6: {
            StringReader sr;
            block5: {
                if (!this.shouldFilter(request, response)) {
                    chain.process(context, request, response);
                    return;
                }
                if (response.getContentType().equals("text/javascript")) {
                    for (ProcessContext.Resource res : context.resources) {
                        Option minurl;
                        if (res.path.endsWith("min.js") || (minurl = this.loader.load(Strings.replace((String)res.path, (String)".js", (String)".min.js"))).isEmpty()) continue;
                        res.url = (URL)minurl.get();
                    }
                }
                chain.process(context, request, response);
                if (!response.getContentType().equals("text/javascript")) break block5;
                for (ProcessContext.Resource res : context.resources) {
                    if (null == res.data || null == res.url || res.url.toString().endsWith("min.js")) continue;
                    sr = new StringReader(new String(res.data, Charsets.UTF_8));
                    JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)sr, null);
                    StringWriter writer = new StringWriter(res.data.length);
                    compressor.compress((Writer)writer, this.lineBreak, false, false, true, true);
                    res.data = writer.getBuffer().toString().getBytes();
                }
                break block6;
            }
            if (!response.getContentType().equals("text/css")) break block6;
            for (ProcessContext.Resource res : context.resources) {
                if (null == res.data) continue;
                sr = new StringReader(new String(res.data, Charsets.UTF_8));
                CssCompressor compressor = new CssCompressor((Reader)sr);
                StringWriter writer = new StringWriter(res.data.length);
                compressor.compress((Writer)writer, this.lineBreak);
                res.data = writer.getBuffer().toString().getBytes();
            }
        }
    }

    public void setLineBreak(int lineBreak) {
        this.lineBreak = lineBreak;
    }

    public void setLoader(ResourceLoader loader) {
        this.loader = loader;
    }
}

