/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.url;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;

public class UriRender {
    private final String context;
    private final String suffix;
    private boolean escapeAmp;

    public UriRender(String context, String suffix) {
        this.suffix = null != suffix ? (suffix.charAt(0) != '.' ? "." + suffix : suffix) : "";
        if (null == context || context.equals("/")) {
            this.context = "";
        } else {
            if (context.endsWith("/")) {
                context = context.substring(0, context.length() - 1);
            }
            if (!context.startsWith("/")) {
                context = "/" + context;
            }
            this.context = context;
        }
    }

    public String render(String referer, String uri, Map<String, String> params) {
        String separator = "&";
        if (this.escapeAmp) {
            separator = "&amp;";
        }
        StringBuilder sb = this.renderUri(referer, uri);
        sb.append(separator);
        for (String key : params.keySet()) {
            try {
                sb.append(key).append('=').append(URLEncoder.encode(params.get(key), "UTF-8"));
                sb.append(separator);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        sb.delete(sb.length() - separator.length(), sb.length());
        return sb.toString();
    }

    public String render(String referer, String uri, String ... params) {
        String separator = "&";
        if (this.escapeAmp) {
            separator = "&amp;";
        }
        StringBuilder sb = this.renderUri(referer, uri);
        sb.append(separator);
        for (String param : params) {
            try {
                sb.append(URLEncoder.encode(param, "UTF-8"));
                sb.append(separator);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        sb.delete(sb.length() - separator.length(), sb.length());
        return sb.toString();
    }

    public String render(String referer, String uri) {
        return this.renderUri(referer, uri).toString();
    }

    private StringBuilder renderUri(String referer, String uri) {
        Assert.notNull((Object)referer);
        StringBuilder sb = new StringBuilder();
        if (Strings.isEmpty((CharSequence)uri)) {
            sb.append(referer);
            return sb;
        }
        String queryStr = null;
        int questIndex = uri.indexOf(63);
        if (-1 == questIndex) {
            questIndex = uri.length();
        } else {
            queryStr = uri.substring(questIndex + 1);
            uri = uri.substring(0, questIndex);
        }
        if (uri.startsWith("/")) {
            sb.append(this.context);
            sb.append(uri.substring(0, questIndex));
        } else {
            int lastslash = referer.lastIndexOf("/");
            String namespace = referer.substring(0, lastslash);
            sb.append(namespace);
            if (uri.startsWith("!")) {
                int dot = referer.indexOf("!", lastslash);
                if (-1 == dot) {
                    dot = referer.indexOf(".", lastslash);
                }
                dot = -1 == dot ? referer.length() : dot;
                String action = referer.substring(lastslash, dot);
                sb.append(action);
                sb.append(uri);
            } else {
                sb.append('/').append(uri);
            }
        }
        if (null != this.suffix) {
            sb.append(this.suffix);
        }
        if (null != queryStr) {
            sb.append('?').append(queryStr);
        }
        return sb;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isEscapeAmp() {
        return this.escapeAmp;
    }

    public void setEscapeAmp(boolean escapeAmp) {
        this.escapeAmp = escapeAmp;
    }
}

