/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.util;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.commons.lang.Strings;

public final class RedirectUtils {
    public static final void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        if (!url.startsWith("http")) {
            String cxtPath = request.getContextPath();
            String redirectUrl = response.encodeRedirectURL((cxtPath.equals("/") ? "" : cxtPath) + url);
            response.sendRedirect(redirectUrl);
        } else {
            response.sendRedirect(url);
        }
    }

    public static boolean isValidRedirectUrl(String url) {
        return Strings.isBlank((CharSequence)url) || url.startsWith("/") || url.toLowerCase().startsWith("http");
    }
}

