/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.util;

import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.beangle.commons.codec.net.BCoder;
import org.beangle.commons.http.agent.Browser;
import org.beangle.commons.http.agent.BrowserCategory;
import org.beangle.commons.http.agent.Os;
import org.beangle.commons.http.agent.OsCategory;
import org.beangle.commons.http.agent.Useragent;
import org.beangle.commons.lang.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestUtils.class);

    private RequestUtils() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getServletPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (Strings.isNotEmpty((CharSequence)servletPath)) {
            return servletPath;
        }
        String uri = request.getRequestURI();
        if (uri.length() == 1) {
            return "";
        }
        String context = request.getContextPath();
        int length = context.length();
        if (length > 2) {
            if ('/' == context.charAt(length - 1)) {
                context = context.substring(0, length - 1);
            }
            servletPath = uri.substring(context.length());
            return servletPath;
        }
        return uri;
    }

    public static String getRealPath(ServletContext servletContext, String path) {
        String realPath;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((realPath = servletContext.getRealPath(path)) == null) {
            throw new RuntimeException("ServletContext resource [" + path + "] cannot be resolved to absolute file path - " + "web application archive not expanded?");
        }
        return realPath;
    }

    public static String encodeAttachName(HttpServletRequest request, String attach_name) {
        String agent = request.getHeader("USER-AGENT");
        String newName = attach_name;
        try {
            newName = null != agent && -1 != agent.indexOf("MSIE") ? URLEncoder.encode(attach_name, "UTF-8") : new BCoder().encode(attach_name);
        }
        catch (Exception e) {
            logger.error("cannot encode " + attach_name, (Throwable)e);
            return attach_name;
        }
        return newName;
    }

    public static Useragent getUserAgent(HttpServletRequest request) {
        String head = request.getHeader("USER-AGENT");
        Useragent agent = new Useragent(RequestUtils.getIpAddr(request), Browser.parse(head), Os.parse(head));
        if (agent.getOs().equals((Object)OsCategory.Unknown) || agent.getBrowser().equals((Object)BrowserCategory.Unknown)) {
            logger.info("Cannot parser user agent:{}", (Object)request.getHeader("USER-AGENT"));
        }
        return agent;
    }
}

