/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.http.agent;

import java.io.Serializable;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.http.agent.OsCategory;
import org.beangle.commons.lang.Strings;

public class Os
implements Serializable,
Comparable<Os> {
    private static final long serialVersionUID = -7506270303767154240L;
    public static Map<String, Os> osMap = CollectUtils.newHashMap();
    public static final Os UNKNOWN = new Os(OsCategory.Unknown, null);
    public final OsCategory category;
    public final String version;

    private Os(OsCategory category, String version) {
        this.category = category;
        this.version = version;
    }

    public String toString() {
        return this.category.getName() + " " + (this.version == null ? "" : this.version);
    }

    public static Os parse(String agentString) {
        if (Strings.isEmpty((CharSequence)agentString)) {
            return UNKNOWN;
        }
        for (OsCategory category : OsCategory.values()) {
            String version = category.match(agentString);
            if (version == null) continue;
            String key = category.getName() + "/" + version;
            Os os = osMap.get(key);
            if (null == os) {
                os = new Os(category, version);
                osMap.put(key, os);
            }
            return os;
        }
        return UNKNOWN;
    }

    @Override
    public int compareTo(Os o) {
        return this.category.compareTo(o.category);
    }
}

