/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.access;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import javax.validation.constraints.NotNull;

public class AccessRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String sessionid;
    @NotNull
    private String username;
    private int status = 200;
    @NotNull
    private String uri;
    private String params;
    @NotNull
    private long beginAt;
    @NotNull
    private long endAt = 0L;

    public AccessRequest() {
    }

    public AccessRequest(String sessionid, String username, String resource) {
        this.sessionid = sessionid;
        this.username = username;
        this.uri = resource;
        this.beginAt = System.currentTimeMillis();
    }

    public long getDuration() {
        if (0L == this.endAt) {
            return System.currentTimeMillis() - this.beginAt;
        }
        return this.endAt - this.beginAt;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getBeginAt() {
        return this.beginAt;
    }

    public void setBeginAt(long beginAt) {
        this.beginAt = beginAt;
    }

    public long getEndAt() {
        return this.endAt;
    }

    public void setEndAt(long endAt) {
        this.endAt = endAt;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.uri);
        sb.append('(');
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
        sb.append(f.format(this.beginAt));
        sb.append('-');
        if (0L != this.endAt) {
            sb.append(f.format(this.endAt));
            sb.append(" duration ").append((this.endAt - this.beginAt) / 1000L).append(" s");
        }
        sb.append(')');
        return sb.toString();
    }
}

