/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.beangle.commons.inject.Container;
import org.beangle.commons.inject.ContainerHook;
import org.beangle.commons.inject.Containers;
import org.beangle.commons.lang.Option;
import org.beangle.commons.lang.Throwables;
import org.beangle.commons.web.filter.GenericHttpFilter;

public class DelegatingFilterProxy
extends GenericHttpFilter
implements ContainerHook {
    private Filter delegate;
    private String targetBeanName;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.delegate.doFilter(request, response, chain);
    }

    public void notify(Container container) {
        try {
            this.setDelegate(this.initDelegate(container));
        }
        catch (ServletException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected void initFilterBean() throws ServletException {
        Container wac;
        if (null == this.targetBeanName) {
            this.targetBeanName = this.getFilterName();
        }
        if ((wac = Containers.getRoot()) != null) {
            this.delegate = this.initDelegate(wac);
        } else {
            Containers.getHooks().add(this);
        }
    }

    @Override
    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    protected Filter initDelegate(Container container) throws ServletException {
        Option delegate = container.getBean((Object)this.targetBeanName);
        ((Filter)delegate.get()).init(this.getFilterConfig());
        return (Filter)delegate.get();
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    protected String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setDelegate(Filter delegate) {
        this.delegate = delegate;
    }
}

