/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.commons.http.mime.MimeTypeProvider;
import org.beangle.commons.io.IOs;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.web.io.DefaultStreamDownloader;

public class SplitStreamDownloader
extends DefaultStreamDownloader {
    public SplitStreamDownloader() {
    }

    public SplitStreamDownloader(MimeTypeProvider mimeTypeProvider) {
        super(mimeTypeProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void download(HttpServletRequest request, HttpServletResponse response, InputStream input, String name, String display) {
        String attach = SplitStreamDownloader.getAttachName(name, display);
        response.reset();
        this.addContent(request, response, attach);
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("connection", "Keep-Alive");
        int length = 0;
        long start = 0L;
        long begin = 0L;
        long stop = 0L;
        Stopwatch watch = new Stopwatch().start();
        try {
            int readed;
            length = input.available();
            stop = length - 1;
            response.setContentLength(length);
            String rangestr = request.getHeader("Range");
            if (null != rangestr) {
                String[] readlength = Strings.substringAfter((String)rangestr, (String)"bytes=").split("-");
                start = Long.parseLong(readlength[0]);
                if (readlength.length > 1 && Strings.isNotEmpty((CharSequence)readlength[1])) {
                    stop = Long.parseLong(readlength[1]);
                }
                if (start != 0L) {
                    response.setStatus(206);
                    String crange = "bytes " + start + "-" + stop + "/" + length;
                    response.setHeader("Content-Range", crange);
                }
            }
            ServletOutputStream output = response.getOutputStream();
            input.skip(start);
            begin = start;
            int size = 4096;
            byte[] buffer = new byte[size];
            int step = this.maxStep(start, stop, size);
            while (step > 0 && (readed = input.read(buffer, 0, step)) != -1) {
                output.write(buffer, 0, readed);
                step = this.maxStep(start += (long)readed, stop, size);
            }
        }
        catch (IOException percent) {
            IOs.close((Closeable)input);
            if (this.logger.isDebugEnabled()) {
                String percent2 = null;
                percent2 = length == 0 ? "100%" : (float)((int)((double)(start - begin) * 1.0 / (double)length * 10000.0)) / 100.0f + "%";
                long time = watch.elapsedMillis();
                int rate = 0;
                if (start - begin > 0L) {
                    rate = (int)((double)(start - begin) * 1.0 / (double)time * 1000.0 / 1024.0);
                }
                this.logger.debug("{}({}-{}/{}) download {}[{}] in {} ms with {} KB/s", this.array(attach, begin, stop, length, start - begin, percent2, time, rate));
            }
        }
        catch (Exception e) {
            this.logger.warn("download file error " + attach, (Throwable)e);
            {
                catch (Throwable throwable) {
                    IOs.close((Closeable)input);
                    if (this.logger.isDebugEnabled()) {
                        String percent3 = null;
                        percent3 = length == 0 ? "100%" : (float)((int)((double)(start - begin) * 1.0 / (double)length * 10000.0)) / 100.0f + "%";
                        long time2 = watch.elapsedMillis();
                        int rate2 = 0;
                        if (start - begin > 0L) {
                            rate2 = (int)((double)(start - begin) * 1.0 / (double)time2 * 1000.0 / 1024.0);
                        }
                        this.logger.debug("{}({}-{}/{}) download {}[{}] in {} ms with {} KB/s", this.array(attach, begin, stop, length, start - begin, percent3, time2, rate2));
                    }
                    throw throwable;
                }
            }
            IOs.close((Closeable)input);
            if (this.logger.isDebugEnabled()) {
                String percent4 = null;
                percent4 = length == 0 ? "100%" : (float)((int)((double)(start - begin) * 1.0 / (double)length * 10000.0)) / 100.0f + "%";
                long time = watch.elapsedMillis();
                int rate = 0;
                if (start - begin > 0L) {
                    rate = (int)((double)(start - begin) * 1.0 / (double)time * 1000.0 / 1024.0);
                }
                this.logger.debug("{}({}-{}/{}) download {}[{}] in {} ms with {} KB/s", this.array(attach, begin, stop, length, start - begin, percent4, time, rate));
            }
        }
        IOs.close((Closeable)input);
        if (this.logger.isDebugEnabled()) {
            String percent = null;
            percent = length == 0 ? "100%" : (float)((int)((double)(start - begin) * 1.0 / (double)length * 10000.0)) / 100.0f + "%";
            long time = watch.elapsedMillis();
            int rate = 0;
            if (start - begin > 0L) {
                rate = (int)((double)(start - begin) * 1.0 / (double)time * 1000.0 / 1024.0);
            }
            this.logger.debug("{}({}-{}/{}) download {}[{}] in {} ms with {} KB/s", this.array(attach, begin, stop, length, start - begin, percent, time, rate));
        }
    }

    private Object[] array(Object ... objects) {
        return objects;
    }

    public int maxStep(long start, long stop, int bufferSize) {
        if (stop - start + 1L >= (long)bufferSize) {
            return bufferSize;
        }
        return (int)(stop - start + 1L);
    }
}

