/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.resource.filter;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.resource.ProcessChain;
import org.beangle.commons.web.resource.ProcessContext;
import org.beangle.commons.web.resource.ResourceFilter;

public class ContentTypeFilter
implements ResourceFilter {
    private Map<String, String> contentTypes = CollectUtils.newHashMap();

    public ContentTypeFilter() {
        this.contentTypes.put("js", "text/javascript");
        this.contentTypes.put("css", "text/css");
        this.contentTypes.put("html", "text/html");
        this.contentTypes.put("htm", "text/html");
        this.contentTypes.put("txt", "text/plain");
        this.contentTypes.put("gif", "image/gif");
        this.contentTypes.put("jpg", "image/jpeg");
        this.contentTypes.put("jpeg", "image/jpeg");
        this.contentTypes.put("png", "image/png");
        this.contentTypes.put("json", "application/json");
        this.contentTypes.put("htc", "text/x-component");
    }

    @Override
    public void filter(ProcessContext context, HttpServletRequest request, HttpServletResponse response, ProcessChain chain) throws IOException {
        String contentType = this.contentTypes.get(Strings.substringAfterLast((String)context.uri, (String)"."));
        if (contentType != null) {
            response.setContentType(contentType);
        }
        chain.process(context, request, response);
    }

    public void setContentTypes(Map<String, String> contentTypes) {
        this.contentTypes = contentTypes;
    }
}

