/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

public final class HttpUtils {
    public static String getResponseText(String urlString) {
        try {
            URL url = new URL(urlString);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            url = uri.toURL();
            return HttpUtils.getResponseText(url, null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getResponseText(URL constructedUrl, String encoding) {
        return HttpUtils.getResponseText(constructedUrl, null, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponseText(URL constructedUrl, HostnameVerifier hostnameVerifier, String encoding) {
        HttpURLConnection conn = null;
        try {
            StringBuffer stringBuffer;
            conn = (HttpURLConnection)constructedUrl.openConnection();
            if (conn instanceof HttpsURLConnection && null != hostnameVerifier) {
                ((HttpsURLConnection)conn).setHostnameVerifier(hostnameVerifier);
            }
            BufferedReader in = null;
            in = null == encoding ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(255);
            synchronized (stringBuffer2) {
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        stringBuffer.append(line);
                        stringBuffer.append("\n");
                    }
                    String string = stringBuffer.toString();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

