/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.filter;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.beangle.commons.http.HttpMethod;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.filter.RequestMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegexRequestMatcher
implements RequestMatcher {
    private static final Logger logger = LoggerFactory.getLogger(RegexRequestMatcher.class);
    private final Pattern pattern;
    private final HttpMethod httpMethod;

    public RegexRequestMatcher(String pattern, String httpMethod) {
        this(pattern, httpMethod, false);
    }

    public RegexRequestMatcher(String pattern, String httpMethod, boolean caseInsensitive) {
        this.pattern = caseInsensitive ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
        this.httpMethod = Strings.isNotEmpty((CharSequence)httpMethod) ? HttpMethod.valueOf(httpMethod) : null;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        if (this.httpMethod != null && this.httpMethod != HttpMethod.valueOf(request.getMethod())) {
            return false;
        }
        String url = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String query = request.getQueryString();
        if (pathInfo != null || query != null) {
            StringBuilder sb = new StringBuilder(url);
            if (pathInfo != null) {
                sb.append(pathInfo);
            }
            if (query != null) {
                sb.append(query);
            }
            url = sb.toString();
        }
        logger.debug("Checking match of request : '{}'; against '{}'", (Object)url, (Object)this.pattern);
        return this.pattern.matcher(url).matches();
    }
}

