/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.http.agent;

import java.io.Serializable;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.http.agent.BrowserCategory;
import org.beangle.commons.http.agent.Engine;
import org.beangle.commons.lang.Strings;

public class Browser
implements Serializable,
Comparable<Browser> {
    private static final long serialVersionUID = -6200607575108416928L;
    public static Map<String, Browser> browsers = CollectUtils.newHashMap();
    public static final Browser UNKNOWN = new Browser(BrowserCategory.Unknown, null);
    public final BrowserCategory category;
    public final String version;

    public Browser(BrowserCategory category, String version) {
        this.category = category;
        this.version = version;
    }

    public static Browser parse(String agentString) {
        if (Strings.isEmpty((CharSequence)agentString)) {
            return UNKNOWN;
        }
        for (Engine engine : Engine.values()) {
            String egineName = engine.name;
            if (!agentString.contains(egineName)) continue;
            for (BrowserCategory category : engine.browserCategories) {
                String version = category.match(agentString);
                if (version == null) continue;
                String key = category.getName() + "/" + version;
                Browser browser = browsers.get(key);
                if (null == browser) {
                    browser = new Browser(category, version);
                    browsers.put(key, browser);
                }
                return browser;
            }
        }
        for (Enum enum_ : BrowserCategory.values()) {
            String version = ((BrowserCategory)enum_).match(agentString);
            if (version == null) continue;
            String key = ((BrowserCategory)enum_).getName() + "/" + version;
            Browser browser = browsers.get(key);
            if (null == browser) {
                browser = new Browser((BrowserCategory)enum_, version);
                browsers.put(key, browser);
            }
            return browser;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.category.getName() + " " + (this.version == null ? "" : this.version);
    }

    @Override
    public int compareTo(Browser o) {
        return this.category.compareTo(o.category);
    }
}

