/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.filter;

import jakarta.servlet.http.HttpServletRequest;
import org.beangle.commons.http.HttpMethod;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.text.regex.AntPathPattern;
import org.beangle.commons.web.filter.RequestMatcher;

public final class AntPathRequestMatcher
implements RequestMatcher {
    private final AntPathPattern pattern;
    private final HttpMethod httpMethod;

    public AntPathRequestMatcher(String pattern) {
        this(pattern, null);
    }

    public AntPathRequestMatcher(String pattern, String httpMethod) {
        Assert.notEmpty((CharSequence)pattern, (String)"Pattern cannot be null or empty", (Object[])new Object[0]);
        this.pattern = new AntPathPattern(pattern);
        this.httpMethod = Strings.isNotEmpty((CharSequence)httpMethod) ? HttpMethod.valueOf(httpMethod) : null;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        if (this.httpMethod != null && this.httpMethod != HttpMethod.valueOf(request.getMethod())) {
            return false;
        }
        Object url = request.getServletPath();
        if (null != request.getPathInfo()) {
            url = (String)url + request.getPathInfo();
        }
        return this.pattern.match((String)url);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AntPathRequestMatcher)) {
            return false;
        }
        AntPathRequestMatcher other = (AntPathRequestMatcher)obj;
        return this.pattern.equals((Object)other.pattern) && this.httpMethod == other.httpMethod;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ant [pattern='").append(this.pattern).append("'");
        if (this.httpMethod != null) {
            sb.append(", " + this.httpMethod);
        }
        sb.append("]");
        return sb.toString();
    }
}

