/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.beangle.commons.lang.Strings;

public class CharacterEncodingFilter
implements Filter {
    protected String encoding = "utf-8";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setCharacterEncoding(this.encoding);
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String initEncoding = filterConfig.getInitParameter("encoding");
        if (Strings.isNotBlank((CharSequence)initEncoding)) {
            this.encoding = initEncoding;
        }
    }

    public void destroy() {
        this.encoding = null;
    }
}

