/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.List;
import org.beangle.commons.web.filter.GenericHttpFilter;

public abstract class GenericCompositeFilter
extends GenericHttpFilter {

    protected static class VirtualFilterChain
    implements FilterChain {
        private final FilterChain originalChain;
        private final List<? extends Filter> additionalFilters;
        private int currentPosition = 0;

        public VirtualFilterChain(FilterChain chain, List<? extends Filter> additionalFilters) {
            this.originalChain = chain;
            this.additionalFilters = additionalFilters;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.currentPosition == this.additionalFilters.size()) {
                this.originalChain.doFilter(request, response);
            } else {
                ++this.currentPosition;
                this.additionalFilters.get(this.currentPosition - 1).doFilter(request, response, (FilterChain)this);
            }
        }
    }
}

