/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.init;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Set;
import org.beangle.commons.web.init.StartupInitializer;

@HandlesTypes(value={StartupInitializer.class})
public class BeangleServletContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> initializerClasses, ServletContext servletContext) throws ServletException {
        LinkedList<StartupInitializer> initializers = new LinkedList<StartupInitializer>();
        if (initializerClasses != null) {
            for (Class<?> waiClass : initializerClasses) {
                if (waiClass.isInterface() || Modifier.isAbstract(waiClass.getModifiers()) || !StartupInitializer.class.isAssignableFrom(waiClass)) continue;
                try {
                    initializers.add((StartupInitializer)waiClass.newInstance());
                }
                catch (Throwable ex) {
                    throw new ServletException("Failed to instantiate StartupInitializer class", ex);
                }
            }
        }
        if (initializers.isEmpty()) {
            servletContext.log("No Beangle StartupInitializer types detected on classpath");
            return;
        }
        servletContext.log("Beangle StartupInitializer detected on classpath: " + initializers);
        for (StartupInitializer initializer : initializers) {
            initializer.onStartup(servletContext);
        }
    }
}

