/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.io;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.http.mime.MimeTypeProvider;
import org.beangle.commons.io.IOs;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.io.StreamDownloader;
import org.beangle.commons.web.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamDownloader
implements Initializing,
StreamDownloader {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MimeTypeProvider mimeTypeProvider;

    public void init() throws Exception {
        Assert.notNull((Object)this.mimeTypeProvider, (String)"mimeTypeProvider must be set", (Object[])new Object[0]);
    }

    public DefaultStreamDownloader() {
    }

    public DefaultStreamDownloader(MimeTypeProvider mimeTypeProvider) {
        this.mimeTypeProvider = mimeTypeProvider;
    }

    @Override
    public void download(HttpServletRequest request, HttpServletResponse response, File file) {
        this.download(request, response, file, file.getName());
    }

    @Override
    public void download(HttpServletRequest request, HttpServletResponse response, URL url, String display) {
        try {
            this.download(request, response, url.openStream(), url.getFile(), display);
        }
        catch (Exception e) {
            this.logger.warn("download file error=" + display, (Throwable)e);
        }
    }

    @Override
    public void download(HttpServletRequest request, HttpServletResponse response, File file, String display) {
        Assert.notNull((Object)file, (String)"file shouldn't be null", (Object[])new Object[0]);
        Assert.isTrue((boolean)file.exists(), (String)"file should exists", (Object[])new Object[0]);
        try {
            this.download(request, response, new FileInputStream(file), file.getAbsolutePath(), display);
        }
        catch (Exception e) {
            this.logger.warn("download file error=" + display, (Throwable)e);
        }
    }

    protected void addContent(HttpServletRequest request, HttpServletResponse response, String attach) {
        String contentType = response.getContentType();
        if (null == contentType) {
            contentType = this.mimeTypeProvider.getMimeType(Strings.substringAfterLast((String)attach, (String)"."), "application/x-msdownload");
            response.setContentType(contentType);
            this.logger.debug("set content type {} for {}", (Object)contentType, (Object)attach);
        }
        String encodeName = RequestUtils.encodeAttachName(request, attach);
        response.setHeader("Content-Disposition", "attachment; filename=" + encodeName);
        response.setHeader("Location", encodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(HttpServletRequest request, HttpServletResponse response, InputStream inStream, String name, String display) {
        String attach_name = DefaultStreamDownloader.getAttachName(name, display);
        try {
            response.reset();
            this.addContent(request, response, attach_name);
            IOs.copy((InputStream)inStream, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            this.logger.warn("download file error " + attach_name, (Throwable)e);
        }
        finally {
            IOs.close((Closeable)inStream);
        }
    }

    public static String getAttachName(String name, String display) {
        Object attch_name = "";
        String ext = Strings.substringAfterLast((String)name, (String)".");
        if (Strings.isBlank((CharSequence)display)) {
            attch_name = DefaultStreamDownloader.getFileName(name);
        } else {
            attch_name = display;
            if (!((String)attch_name).endsWith("." + ext)) {
                attch_name = (String)attch_name + "." + ext;
            }
        }
        return attch_name;
    }

    protected static String getFileName(String file_name) {
        if (file_name == null) {
            return "";
        }
        file_name = file_name.trim();
        int iPos = 0;
        iPos = file_name.lastIndexOf("\\");
        if (iPos > -1) {
            file_name = file_name.substring(iPos + 1);
        }
        if ((iPos = file_name.lastIndexOf("/")) > -1) {
            file_name = file_name.substring(iPos + 1);
        }
        if ((iPos = file_name.lastIndexOf(File.separator)) > -1) {
            file_name = file_name.substring(iPos + 1);
        }
        return file_name;
    }

    public void setMimeTypeProvider(MimeTypeProvider mimeTypeProvider) {
        this.mimeTypeProvider = mimeTypeProvider;
    }
}

