/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.url;

import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.Strings;

public class UrlBuilder {
    private String scheme;
    private String serverName;
    private int port;
    private String contextPath;
    private String servletPath;
    private String requestURI;
    private String pathInfo;
    private String queryString;

    public UrlBuilder(String contextPath) {
        this.contextPath = Strings.isEmpty((CharSequence)contextPath) ? "/" : contextPath.trim();
    }

    private String buildServletPath() {
        String uri = this.servletPath;
        if (uri == null && null != this.requestURI) {
            uri = this.requestURI;
            if (!this.contextPath.equals("/")) {
                uri = uri.substring(this.contextPath.length());
            }
        }
        return null == uri ? "" : uri;
    }

    public String buildRequestUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildServletPath());
        if (null != this.pathInfo) {
            sb.append(this.pathInfo);
        }
        if (null != this.queryString) {
            sb.append('?').append(this.queryString);
        }
        return sb.toString();
    }

    public String buildUrl() {
        StringBuilder sb = new StringBuilder();
        boolean includePort = true;
        if (null != this.scheme) {
            sb.append(this.scheme).append("://");
            boolean bl = includePort = this.port != (this.scheme.equals("http") ? 80 : 443);
        }
        if (null != this.serverName) {
            sb.append(this.serverName);
            if (includePort && this.port > 0) {
                sb.append(':').append(this.port);
            }
        }
        if (!Objects.equals((Object)this.contextPath, (Object)"/")) {
            sb.append(this.contextPath);
        }
        sb.append(this.buildRequestUrl());
        return sb.toString();
    }

    public UrlBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public UrlBuilder serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public UrlBuilder port(int port) {
        this.port = port;
        return this;
    }

    public UrlBuilder contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public UrlBuilder servletPath(String servletPath) {
        this.servletPath = servletPath;
        return this;
    }

    public UrlBuilder requestURI(String requestURI) {
        this.requestURI = requestURI;
        return this;
    }

    public UrlBuilder pathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
        return this;
    }

    public UrlBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }
}

