/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.util;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CookieUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CookieUtils.class);

    private CookieUtils() {
    }

    public static String getCookieValue(Cookie cookie) {
        try {
            return URLDecoder.decode(cookie.getValue(), "utf-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        try {
            Cookie cookie = CookieUtils.getCookie(request, cookieName);
            if (null == cookie) {
                return null;
            }
            return URLDecoder.decode(cookie.getValue(), "utf-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        Cookie returnCookie = null;
        if (cookies == null) {
            return returnCookie;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie thisCookie = cookies[i];
            if (!thisCookie.getName().equals(name) || thisCookie.getValue().equals("")) continue;
            returnCookie = thisCookie;
            break;
        }
        return returnCookie;
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String path, int age) {
        LOG.debug("add cookie[name:{},value={},path={}]", new Object[]{name, value, path});
        Cookie cookie = null;
        try {
            cookie = new Cookie(name, URLEncoder.encode(value, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        cookie.setSecure(false);
        cookie.setPath(path);
        cookie.setMaxAge(age);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int age) {
        Object contextPath = request.getContextPath();
        if (!((String)contextPath).endsWith("/")) {
            contextPath = (String)contextPath + "/";
        }
        CookieUtils.addCookie(request, response, name, value, (String)contextPath, age);
    }

    public static void deleteCookieByName(HttpServletRequest request, HttpServletResponse response, String name) {
        CookieUtils.deleteCookie(response, CookieUtils.getCookie(request, name), "");
    }

    public static void deleteCookie(HttpServletResponse response, Cookie cookie, String path) {
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setPath(path);
            response.addCookie(cookie);
        }
    }
}

