/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.beangle.commons.io.IOs;
import org.beangle.commons.web.util.Https;

public final class HttpUtils {
    public static String getResponseText(String urlString) {
        try {
            URL url = new URL(urlString);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            url = uri.toURL();
            return HttpUtils.getResponseText(url, null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponseText(URL constructedUrl, String encoding) {
        HttpURLConnection conn = null;
        try {
            StringBuffer stringBuffer;
            conn = (HttpURLConnection)constructedUrl.openConnection();
            Https.noverify(conn);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            BufferedReader in = null;
            in = null == encoding ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(255);
            synchronized (stringBuffer2) {
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        stringBuffer.append(line);
                        stringBuffer.append("\n");
                    }
                    String string = stringBuffer.toString();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getData(String urlString) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            Https.noverify(conn);
            if (conn.getResponseCode() == 200) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOs.copy((InputStream)conn.getInputStream(), (OutputStream)bos);
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            byte[] byArray = new byte[]{};
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }
}

