/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.util;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.beangle.commons.codec.net.BCoder;
import org.beangle.commons.http.agent.Browser;
import org.beangle.commons.http.agent.BrowserCategory;
import org.beangle.commons.http.agent.Os;
import org.beangle.commons.http.agent.OsCategory;
import org.beangle.commons.http.agent.Useragent;
import org.beangle.commons.lang.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestUtils.class);

    private RequestUtils() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getServletPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (Strings.isNotEmpty((CharSequence)servletPath)) {
            return servletPath;
        }
        String uri = request.getRequestURI();
        if (uri.length() == 1) {
            return "";
        }
        String context = request.getContextPath();
        int length = context.length();
        if (length > 2) {
            if ('/' == context.charAt(length - 1)) {
                context = context.substring(0, length - 1);
            }
            servletPath = uri.substring(context.length());
            return servletPath;
        }
        return uri;
    }

    public static String encodeAttachName(HttpServletRequest request, String attach_name) {
        String agent = request.getHeader("USER-AGENT");
        String newName = attach_name;
        try {
            newName = null != agent && (agent.contains("MSIE") || agent.contains("Trident")) ? URLEncoder.encode(attach_name, "UTF-8") : new BCoder().encode(attach_name);
        }
        catch (Exception e) {
            logger.error("cannot encode " + attach_name, (Throwable)e);
            return attach_name;
        }
        return newName;
    }

    public static Useragent getUserAgent(HttpServletRequest request) {
        String head = request.getHeader("USER-AGENT");
        Useragent agent = new Useragent(RequestUtils.getIpAddr(request), Browser.parse(head), Os.parse(head));
        if (agent.getOs().equals((Object)OsCategory.Unknown) || agent.getBrowser().equals((Object)BrowserCategory.Unknown)) {
            logger.info("Cannot parser user agent:{}", (Object)request.getHeader("USER-AGENT"));
        }
        return agent;
    }

    public static Map getParams(HttpServletRequest request, String prefix) {
        return RequestUtils.getParamsMap(request, prefix, null, true);
    }

    public static Map getParams(HttpServletRequest request, String prefix, String exclusiveAttrNames) {
        return RequestUtils.getParamsMap(request, prefix, exclusiveAttrNames, true);
    }

    public static Map getParamsMap(HttpServletRequest request, String prefix, String exclusiveAttrNames) {
        return RequestUtils.getParamsMap(request, prefix, exclusiveAttrNames, false);
    }

    public static Map getParamsMap(HttpServletRequest request, String prefix, String exclusiveAttrNames, boolean stripPrefix) {
        HashMap<String, String> params = new HashMap<String, String>();
        exclusiveAttrNames = Strings.isNotEmpty((CharSequence)exclusiveAttrNames) ? "," + (String)exclusiveAttrNames + "," : null;
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String attr = (String)names.nextElement();
            if (attr.indexOf(prefix + ".") != 0 || null != exclusiveAttrNames && Strings.contains((CharSequence)exclusiveAttrNames, (CharSequence)("," + attr + ","))) continue;
            params.put(stripPrefix ? attr.substring(prefix.length() + 1) : attr, request.getParameter(attr));
        }
        String queryString = request.getQueryString();
        if (Strings.isNotEmpty((CharSequence)queryString)) {
            String[] paramPairs = Strings.split((String)queryString, (String)"&");
            for (int i = 0; i < paramPairs.length; ++i) {
                String param;
                int equalIndex;
                String paramPair = paramPairs[i];
                if (paramPair.indexOf(prefix + ".") != 0 || -1 == (equalIndex = paramPair.indexOf("=")) || Strings.contains((CharSequence)exclusiveAttrNames, (CharSequence)("," + (param = paramPair.substring(0, equalIndex)) + ","))) continue;
                try {
                    params.put(stripPrefix ? param.substring(prefix.length() + 1) : param, URLDecoder.decode(paramPair.substring(equalIndex + 1), "UTF-8"));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return params;
    }

    public static String get(HttpServletRequest request, String name) {
        return request.getParameter(name);
    }

    public static Float getFloat(HttpServletRequest request, String name) {
        String v = request.getParameter(name);
        return Strings.isBlank((CharSequence)v) ? null : Float.valueOf(v);
    }

    public static Integer getInteger(HttpServletRequest request, String name) {
        String v = request.getParameter(name);
        return Strings.isBlank((CharSequence)v) ? null : Integer.valueOf(v);
    }

    public static Long getLong(HttpServletRequest request, String name) {
        String v = request.getParameter(name);
        return Strings.isBlank((CharSequence)v) ? null : Long.valueOf(v);
    }

    public static Boolean getBoolean(HttpServletRequest request, String name) {
        String v = request.getParameter(name);
        if (Strings.isBlank((CharSequence)v)) {
            return null;
        }
        if (v.equals("1") || v.equals("true") || v.equals("yes") || v.equals("on")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Date getDate(HttpServletRequest request, String name) {
        String dateStr = RequestUtils.get(request, name);
        if (Strings.isBlank((CharSequence)dateStr)) {
            return null;
        }
        return Date.valueOf(dateStr);
    }

    public static boolean isHttps(HttpServletRequest req) {
        return req.getScheme().equals("https") || "https".equals(req.getHeader("X-Forwarded-Proto"));
    }

    public static int getServerPort(HttpServletRequest req) {
        String headPort = req.getHeader("X-Forwarded-Port");
        if (Strings.isEmpty((CharSequence)headPort)) {
            return req.getServerPort();
        }
        return Integer.parseInt(headPort);
    }
}

