/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.web.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.commons.logging.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class CookieUtils$
implements Logging {
    public static final CookieUtils$ MODULE$;
    private final Logger org$beangle$commons$logging$Logging$$logger;

    static {
        new CookieUtils$();
    }

    public Logger org$beangle$commons$logging$Logging$$logger() {
        return this.org$beangle$commons$logging$Logging$$logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$org$beangle$commons$logging$Logging$$logger_$eq(Logger x$1) {
        this.org$beangle$commons$logging$Logging$$logger = x$1;
    }

    public final boolean debugEnabled() {
        return Logging.class.debugEnabled((Logging)this);
    }

    public final void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public final void trace(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public final void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public final void debug(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public final void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public final void info(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public final void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public final void warn(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public final void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public final void error(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public String getCookieValue(Cookie cookie) {
        String string;
        try {
            string = URLDecoder.decode(cookie.getValue(), "utf-8");
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getCookieValue(HttpServletRequest request, String cookieName) {
        String string;
        try {
            Cookie cookie = this.getCookie(request, cookieName);
            string = cookie == null ? null : URLDecoder.decode(cookie.getValue(), "utf-8");
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        ObjectRef returnCookie = ObjectRef.create(null);
        if (cookies == null) {
            return (Cookie)returnCookie.elem;
        }
        Predef$ predef$ = Predef$.MODULE$;
        RichInt$.MODULE$.until$extension0(0, cookies.length).withFilter((Function1)new Serializable(returnCookie){
            private final ObjectRef returnCookie$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return (Cookie)this.returnCookie$1.elem == null;
            }
            {
                this.returnCookie$1 = returnCookie$1;
            }
        }).foreach((Function1)new Serializable(name, cookies, returnCookie){
            private final String name$1;
            private final Cookie[] cookies$1;
            private final ObjectRef returnCookie$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Cookie thisCookie = this.cookies$1[i];
                String string = thisCookie.getName();
                String string2 = this.name$1;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    String string3 = thisCookie.getValue();
                    if (string3 == null || !string3.equals("")) {
                        this.returnCookie$1.elem = thisCookie;
                    }
                }
            }
            {
                this.name$1 = name$1;
                this.cookies$1 = cookies$1;
                this.returnCookie$1 = returnCookie$1;
            }
        });
        return (Cookie)returnCookie.elem;
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String path, int age) {
        this.debug((Function0<String>)new Serializable(name, value, path){
            private final String name$2;
            private final String value$1;
            private final String path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add cookie[name:", ",value=", ",path=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2, this.value$1, this.path$1}));
            }
            {
                this.name$2 = name$2;
                this.value$1 = value$1;
                this.path$1 = path$1;
            }
        });
        Cookie cookie = new Cookie(name, URLEncoder.encode(value, "utf-8"));
        cookie.setSecure(false);
        cookie.setPath(path);
        cookie.setMaxAge(age);
        response.addCookie(cookie);
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int age) {
        String contextPath = request.getContextPath().endsWith("/") ? request.getContextPath() : new StringBuilder().append((Object)request.getContextPath()).append((Object)"/").toString();
        this.addCookie(request, response, name, value, contextPath, age);
    }

    public void deleteCookieByName(HttpServletRequest request, HttpServletResponse response, String name) {
        this.deleteCookie(response, this.getCookie(request, name), "");
    }

    public void deleteCookie(HttpServletResponse response, Cookie cookie, String path) {
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setPath(path);
            response.addCookie(cookie);
        }
    }

    private CookieUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

