/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.csv.internal;

import org.beangle.commons.csv.CsvFormat;
import org.beangle.commons.csv.internal.CsvParser$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public class CsvParser {
    private CsvFormat format;
    private String pending;
    private boolean inField;
    private final boolean ignoreLeadingWhiteSpace;

    public static int InitialReadSize() {
        return CsvParser$.MODULE$.InitialReadSize();
    }

    public CsvParser(CsvFormat format) {
        this.format = format;
        this.inField = false;
        this.ignoreLeadingWhiteSpace = true;
    }

    public CsvFormat format() {
        return this.format;
    }

    public void format_$eq(CsvFormat x$1) {
        this.format = x$1;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public String[] parseLineMulti(String nextLine) {
        return this.parseLine(nextLine, true);
    }

    public String[] parseLine(String nextLine) {
        return this.parseLine(nextLine, false);
    }

    private String[] parseLine(String nextLine, boolean multi) {
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String s = this.pending;
                this.pending = null;
                return new String[]{s};
            }
            return null;
        }
        ListBuffer tokensOnThisLine = new ListBuffer();
        StringBuilder sb = new StringBuilder(CsvParser$.MODULE$.InitialReadSize());
        boolean inQuotes = false;
        if (this.pending != null) {
            sb.append(this.pending);
            this.pending = null;
            inQuotes = true;
        }
        for (int i = 0; i < nextLine.length(); ++i) {
            char c = nextLine.charAt(i);
            if (this.format().isEscape(c)) {
                if (!this.isNextCharacterEscapable(nextLine, inQuotes || this.inField, i)) continue;
                sb.append(nextLine.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == this.format().delimiter()) {
                if (this.isNextCharacterEscapedQuote(nextLine, inQuotes || this.inField, i)) {
                    sb.append(nextLine.charAt(i + 1));
                    ++i;
                } else {
                    boolean bl = inQuotes = !inQuotes;
                    if (!(this.format().strictQuotes() || i <= 2 || this.format().isSeparator(nextLine.charAt(i - 1)) || nextLine.length() <= i + 1 || this.format().isSeparator(nextLine.charAt(i + 1)))) {
                        if (this.ignoreLeadingWhiteSpace && sb.length() > 0 && this.isAllWhiteSpace((CharSequence)sb)) {
                            sb = new StringBuilder(CsvParser$.MODULE$.InitialReadSize());
                        } else {
                            sb.append(c);
                        }
                    }
                }
                this.inField = !this.inField;
                continue;
            }
            if (this.format().isSeparator(c) && !inQuotes) {
                tokensOnThisLine.$plus$eq((Object)sb.toString());
                sb = new StringBuilder(CsvParser$.MODULE$.InitialReadSize());
                this.inField = false;
                continue;
            }
            if (this.format().strictQuotes() && !inQuotes) continue;
            sb.append(c);
            this.inField = true;
        }
        if (inQuotes) {
            if (multi) {
                sb.append("\n");
                this.pending = sb.toString();
                sb = null;
            } else {
                throw new RuntimeException("Un-terminated Quoted field at end of CSV line");
            }
        }
        if (sb != null) {
            tokensOnThisLine.$plus$eq((Object)sb.toString());
        }
        return (String[])tokensOnThisLine.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && this.format().isDelimiter(nextLine.charAt(i + 1));
    }

    public boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && (this.format().isDelimiter(nextLine.charAt(i + 1)) || this.format().isEscape(nextLine.charAt(i + 1)));
    }

    public boolean isAllWhiteSpace(CharSequence sb) {
        boolean result = true;
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return result;
    }
}

