/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dbf;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import org.beangle.commons.dbf.DataType;
import org.beangle.commons.dbf.DataType$;
import org.beangle.commons.dbf.DbfException;
import org.beangle.commons.dbf.Field;
import scala.Byte$;
import scala.runtime.ModuleSerializationProxy;

public final class Field$
implements Serializable {
    private static final int HEADER_TERMINATOR;
    public static final Field$ MODULE$;

    private Field$() {
    }

    static {
        MODULE$ = new Field$();
        HEADER_TERMINATOR = 13;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Field$.class);
    }

    public int HEADER_TERMINATOR() {
        return HEADER_TERMINATOR;
    }

    public Field read(DataInput in, int index) {
        Field field;
        try {
            int nonZeroIndex;
            byte firstByte = in.readByte();
            if (firstByte == this.HEADER_TERMINATOR()) {
                return null;
            }
            byte[] nameBuf = new byte[11];
            in.readFully(nameBuf, 1, 10);
            nameBuf[0] = firstByte;
            for (nonZeroIndex = nameBuf.length - 1; nonZeroIndex >= 0 && nameBuf[nonZeroIndex] == 0; --nonZeroIndex) {
            }
            String name = new String(nameBuf, 0, nonZeroIndex + 1);
            byte fieldType = in.readByte();
            DataType dataType = DataType$.MODULE$.valueOf(fieldType);
            if (dataType == null) {
                throw new DbfException(String.format("Unsupported Dbf field type: %s", Integer.toString(Byte$.MODULE$.byte2int(fieldType), 16)));
            }
            in.skipBytes(4);
            int fieldLength = in.readUnsignedByte();
            byte decimalCount = in.readByte();
            in.skipBytes(2);
            byte workAreaId = in.readByte();
            in.skipBytes(2);
            byte setFieldsFlag = in.readByte();
            in.skipBytes(7);
            byte indexFieldFlag = in.readByte();
            field = new Field(index, name, dataType, fieldLength, decimalCount, workAreaId, setFieldsFlag, indexFieldFlag);
        }
        catch (IOException e) {
            throw new DbfException("Cannot read Dbf field", e);
        }
        return field;
    }
}

