/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dbf;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import org.beangle.commons.dbf.DbfException;
import org.beangle.commons.dbf.DbfUtils$;
import org.beangle.commons.dbf.Field;
import org.beangle.commons.dbf.Field$;
import org.beangle.commons.dbf.Header;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;

public final class Header$
implements Serializable {
    public static final Header$ MODULE$ = new Header$();

    private Header$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Header$.class);
    }

    public Header read(DataInput dataInput) {
        Header header;
        try {
            byte signature = dataInput.readByte();
            byte year = dataInput.readByte();
            byte month = dataInput.readByte();
            byte day = dataInput.readByte();
            int numberOfRecords = DbfUtils$.MODULE$.readLittleEndianInt(dataInput);
            short headerLength = DbfUtils$.MODULE$.readLittleEndianShort(dataInput);
            short recordLength = DbfUtils$.MODULE$.readLittleEndianShort(dataInput);
            dataInput.skipBytes(2);
            byte incompleteTransaction = dataInput.readByte();
            byte encryptionFlag = dataInput.readByte();
            dataInput.skipBytes(12);
            byte mdxFlag = dataInput.readByte();
            byte languageDriver = dataInput.readByte();
            short reserv4 = DbfUtils$.MODULE$.readLittleEndianShort(dataInput);
            ListBuffer fields = new ListBuffer();
            int fieldIndex = 0;
            Field field = Field$.MODULE$.read(dataInput, fieldIndex);
            while (field != null) {
                fields.$plus$eq((Object)field);
                field = Field$.MODULE$.read(dataInput, ++fieldIndex);
            }
            header = new Header(signature, year, month, day, numberOfRecords, headerLength, recordLength, incompleteTransaction, encryptionFlag, mdxFlag, languageDriver, (Field[])fields.toArray(ClassTag$.MODULE$.apply(Field.class)));
        }
        catch (IOException e) {
            throw new DbfException("Cannot read Dbf header", e);
        }
        return header;
    }
}

