/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dbf;

import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.GregorianCalendar;
import org.beangle.commons.dbf.DataType;
import org.beangle.commons.dbf.DataType$;
import org.beangle.commons.dbf.DbfException;
import org.beangle.commons.dbf.DbfUtils$;
import org.beangle.commons.dbf.Field;
import org.beangle.commons.dbf.Header;
import org.beangle.commons.dbf.Reader$;
import org.beangle.commons.lang.Strings$;
import scala.Byte$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class Reader
implements Closeable {
    private final DataInput dataInput;
    private final Header header;

    public static Reader apply(File file) {
        return Reader$.MODULE$.apply(file);
    }

    public static Reader apply(InputStream inputStream) {
        return Reader$.MODULE$.apply(inputStream);
    }

    public static String readInfo(File file) {
        return Reader$.MODULE$.readInfo(file);
    }

    public static void writeToCsv(File file, File file2, Charset charset) {
        Reader$.MODULE$.writeToCsv(file, file2, charset);
    }

    public Reader(DataInput dataInput, Header header) {
        this.dataInput = dataInput;
        this.header = header;
        this.skipToDataBeginning();
    }

    public Header header() {
        return this.header;
    }

    private void skipToDataBeginning() {
        int dataStartIndex = this.header().headerSize() - 32 * (this.header().fieldsCount() + 1) - 1;
        if (dataStartIndex > 0) {
            this.dataInput.skipBytes(dataStartIndex);
            return;
        }
    }

    public boolean canSeek() {
        return this.dataInput instanceof RandomAccessFile;
    }

    public void seekToRecord(int n) {
        if (!this.canSeek()) {
            throw new DbfException("Seeking is not supported.");
        }
        if (n < 0 || n >= this.header().numberOfRecords()) {
            throw new DbfException(Strings$.MODULE$.format("Record index out of range [0, %d]: %d", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.header().numberOfRecords()), BoxesRunTime.boxToInteger((int)n)})));
        }
        int position = this.header().headerSize() + n * this.header().recordSize();
        try {
            ((RandomAccessFile)this.dataInput).seek(Int$.MODULE$.int2long(position));
        }
        catch (IOException e) {
            throw new DbfException(Strings$.MODULE$.format("Failed to seek to record %d of %d", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.header().numberOfRecords())})), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object[] nextRecord() {
        Object[] objectArray;
        try {
            void var2_2;
            int nextByte = 0;
            do {
                if ((nextByte = Byte$.MODULE$.byte2int(this.dataInput.readByte())) == Reader$.org$beangle$commons$dbf$Reader$$$DATA_ENDED) {
                    return null;
                }
                if (nextByte != Reader$.org$beangle$commons$dbf$Reader$$$DATA_DELETED) continue;
                this.dataInput.skipBytes(this.header().recordSize() - 1);
            } while (nextByte == Reader$.org$beangle$commons$dbf$Reader$$$DATA_DELETED);
            Object[] recordObjects = new Object[this.header().fieldsCount()];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.header().fieldsCount()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                recordObjects$1[i] = this.readFieldValue(this.header().fields()[i]);
            });
            objectArray = var2_2;
        }
        catch (EOFException e) {
            objectArray = null;
        }
        catch (IOException e) {
            throw new DbfException("Cannot read next record form Dbf file", e);
        }
        return objectArray;
    }

    private Object readFieldValue(Field field) {
        byte[] buf = new byte[field.fieldLength()];
        this.dataInput.readFully(buf);
        DataType dataType = field.dataType();
        DataType dataType2 = DataType$.Char;
        DataType dataType3 = dataType;
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            return this.readCharacterValue(field, buf);
        }
        DataType dataType4 = DataType$.Date;
        DataType dataType5 = dataType;
        if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
            return this.readDateValue(field, buf);
        }
        DataType dataType6 = DataType$.Float;
        DataType dataType7 = dataType;
        if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
            return this.readFloatValue(field, buf);
        }
        DataType dataType8 = DataType$.Logical;
        DataType dataType9 = dataType;
        if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
            return this.readLogicalValue(field, buf);
        }
        DataType dataType10 = DataType$.Numeric;
        DataType dataType11 = dataType;
        if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
            return this.readNumericValue(field, buf);
        }
        if (dataType == null) {
            return null;
        }
        throw new MatchError((Object)dataType);
    }

    public Object readCharacterValue(Field field, byte[] buf) {
        return buf;
    }

    public Date readDateValue(Field field, byte[] buf) {
        int year = DbfUtils$.MODULE$.parseInt(buf, 0, 4);
        int month = DbfUtils$.MODULE$.parseInt(buf, 4, 6);
        int day = DbfUtils$.MODULE$.parseInt(buf, 6, 8);
        return new GregorianCalendar(year, month - 1, day).getTime();
    }

    public Float readFloatValue(Field field, byte[] buf) {
        Float f;
        try {
            boolean processable;
            byte[] floatBuf = DbfUtils$.MODULE$.trimLeftSpaces(buf);
            boolean bl = processable = floatBuf.length > 0 && !DbfUtils$.MODULE$.contains(floatBuf, (byte)63);
            f = processable ? Float.valueOf(new String(floatBuf)) : null;
        }
        catch (NumberFormatException e) {
            throw new DbfException("Failed to parse Float from " + field.name(), e);
        }
        return f;
    }

    public Boolean readLogicalValue(Field field, byte[] buf) {
        boolean isTrue;
        boolean bl = isTrue = buf[0] == 89 || buf[0] == 121 || buf[0] == 84 || buf[0] == 116;
        if (isTrue) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Number readNumericValue(Field field, byte[] buf) {
        Double d;
        try {
            boolean processable;
            byte[] numericBuf = DbfUtils$.MODULE$.trimLeftSpaces(buf);
            boolean bl = processable = numericBuf.length > 0 && !DbfUtils$.MODULE$.contains(numericBuf, (byte)63);
            d = processable ? Double.valueOf(new String(numericBuf)) : null;
        }
        catch (NumberFormatException e) {
            throw new DbfException("Failed to parse Number from " + field.name(), e);
        }
        return d;
    }

    @Override
    public void close() {
        DataInput dataInput = this.dataInput;
        if (dataInput instanceof Closeable) {
            Closeable c = (Closeable)((Object)dataInput);
            c.close();
            return;
        }
    }
}

